/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;

public class GenerateForLoopAssistProposal
extends LinkedCorrectionProposal {
    public static final int GENERATE_FOREACH = 0;
    public static final int GENERATE_ITERATOR_FOR = 1;
    public static final int GENERATE_ITERATE_ARRAY = 2;
    public static final int GENERATE_ITERATE_LIST = 3;
    private ASTNode fCurrentNode;
    private Expression fCurrentExpression;
    private ITypeBinding fExpressionType;
    private int fLoopTypeToGenerate = -1;

    public GenerateForLoopAssistProposal(ICompilationUnit cu, ITypeBinding expressionType, ASTNode currentNode, Expression currentExpression, int loopTypeToGenerate) {
        super("", cu, (ASTRewrite)null, 1, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fCurrentNode = currentNode;
        this.fCurrentExpression = currentExpression;
        this.fLoopTypeToGenerate = loopTypeToGenerate;
        this.fExpressionType = expressionType;
        switch (loopTypeToGenerate) {
            case 0: {
                this.setDisplayName(CorrectionMessages.QuickAssistProcessor_generate_enhanced_for_loop);
                this.setRelevance(2);
                break;
            }
            case 1: {
                this.setDisplayName(CorrectionMessages.QuickAssistProcessor_generate_iterator_for_loop);
                break;
            }
            case 2: {
                this.setDisplayName(CorrectionMessages.QuickAssistProcessor_generate_for_loop);
                break;
            }
            case 3: {
                this.setDisplayName(CorrectionMessages.QuickAssistProcessor_generate_index_for_loop);
                break;
            }
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fCurrentNode.getAST();
        this.createImportRewrite((CompilationUnit)this.fCurrentExpression.getRoot());
        switch (this.fLoopTypeToGenerate) {
            case 0: {
                return this.generateForEachRewrite(ast);
            }
            case 1: {
                return this.generateIteratorBasedForRewrite(ast);
            }
            case 2: {
                return this.generateForRewrite(ast);
            }
            case 3: {
                return this.generateIndexBasedForRewrite(ast);
            }
        }
        return null;
    }

    private ASTRewrite generateForEachRewrite(AST ast) {
        EnhancedForStatement loopStatement = ast.newEnhancedForStatement();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ITypeBinding loopOverType = this.extractElementType(ast);
        SimpleName forDeclarationName = this.resolveLinkedVariableNameWithProposals(rewrite, loopOverType.getName(), null, true);
        SingleVariableDeclaration forLoopInitializer = ast.newSingleVariableDeclaration();
        forLoopInitializer.setType(this.getImportRewrite().addImport(loopOverType, ast, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(this.fCurrentNode, this.getImportRewrite())));
        forLoopInitializer.setName(forDeclarationName);
        loopStatement.setParameter(forLoopInitializer);
        loopStatement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression));
        Block forLoopBody = ast.newBlock();
        forLoopBody.statements().add(this.createBlankLineStatementWithCursorPosition(rewrite));
        loopStatement.setBody((Statement)forLoopBody);
        rewrite.replace(this.fCurrentNode, (ASTNode)loopStatement, null);
        return rewrite;
    }

    private ASTRewrite generateIteratorBasedForRewrite(AST ast) {
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ForStatement loopStatement = ast.newForStatement();
        ITypeBinding loopOverType = this.extractElementType(ast);
        SimpleName loopVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, "iterator", null, true);
        loopStatement.initializers().add(this.getIteratorBasedForInitializer(rewrite, loopVariableName));
        MethodInvocation loopExpression = ast.newMethodInvocation();
        loopExpression.setName(ast.newSimpleName("hasNext"));
        SimpleName expressionName = ast.newSimpleName(loopVariableName.getIdentifier());
        this.addLinkedPosition(rewrite.track((ASTNode)expressionName), -1, expressionName.getIdentifier());
        loopExpression.setExpression((Expression)expressionName);
        loopStatement.setExpression((Expression)loopExpression);
        Block forLoopBody = ast.newBlock();
        Assignment assignResolvedVariable = this.getIteratorBasedForBodyAssignment(rewrite, loopOverType, loopVariableName);
        forLoopBody.statements().add(ast.newExpressionStatement((Expression)assignResolvedVariable));
        forLoopBody.statements().add(this.createBlankLineStatementWithCursorPosition(rewrite));
        loopStatement.setBody((Statement)forLoopBody);
        rewrite.replace(this.fCurrentNode, (ASTNode)loopStatement, null);
        return rewrite;
    }

    private VariableDeclarationExpression getIteratorBasedForInitializer(ASTRewrite rewrite, SimpleName loopVariableName) {
        AST ast = rewrite.getAST();
        IMethodBinding iteratorMethodBinding = Bindings.findMethodInHierarchy(this.fExpressionType, "iterator", new ITypeBinding[0]);
        VariableDeclarationFragment varDeclarationFragment = ast.newVariableDeclarationFragment();
        varDeclarationFragment.setName(loopVariableName);
        MethodInvocation iteratorExpression = ast.newMethodInvocation();
        iteratorExpression.setName(ast.newSimpleName(iteratorMethodBinding.getName()));
        iteratorExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression));
        varDeclarationFragment.setInitializer((Expression)iteratorExpression);
        VariableDeclarationExpression varDeclarationExpression = ast.newVariableDeclarationExpression(varDeclarationFragment);
        varDeclarationExpression.setType(this.getImportRewrite().addImport(iteratorMethodBinding.getReturnType(), ast, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(this.fCurrentNode, this.getImportRewrite())));
        return varDeclarationExpression;
    }

    private Assignment getIteratorBasedForBodyAssignment(ASTRewrite rewrite, ITypeBinding loopOverType, SimpleName loopVariableName) {
        AST ast = rewrite.getAST();
        Assignment assignResolvedVariable = ast.newAssignment();
        SimpleName resolvedVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, loopOverType.getName(), loopVariableName.getIdentifier(), false);
        VariableDeclarationFragment resolvedVariableDeclarationFragment = ast.newVariableDeclarationFragment();
        resolvedVariableDeclarationFragment.setName(resolvedVariableName);
        VariableDeclarationExpression resolvedVariableDeclaration = ast.newVariableDeclarationExpression(resolvedVariableDeclarationFragment);
        resolvedVariableDeclaration.setType(this.getImportRewrite().addImport(loopOverType, ast, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(this.fCurrentNode, this.getImportRewrite())));
        assignResolvedVariable.setLeftHandSide((Expression)resolvedVariableDeclaration);
        MethodInvocation invokeIteratorNextExpression = ast.newMethodInvocation();
        invokeIteratorNextExpression.setName(ast.newSimpleName("next"));
        SimpleName currentElementName = ast.newSimpleName(loopVariableName.getIdentifier());
        this.addLinkedPosition(rewrite.track((ASTNode)currentElementName), -1, currentElementName.getIdentifier());
        invokeIteratorNextExpression.setExpression((Expression)currentElementName);
        assignResolvedVariable.setRightHandSide((Expression)invokeIteratorNextExpression);
        assignResolvedVariable.setOperator(Assignment.Operator.ASSIGN);
        return assignResolvedVariable;
    }

    private ASTRewrite generateForRewrite(AST ast) {
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ForStatement loopStatement = ast.newForStatement();
        SimpleName loopVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, "int", null, true);
        loopStatement.initializers().add(this.getForInitializer(ast, loopVariableName));
        FieldAccess getArrayLengthExpression = ast.newFieldAccess();
        getArrayLengthExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression));
        getArrayLengthExpression.setName(ast.newSimpleName("length"));
        loopStatement.setExpression((Expression)this.getLinkedInfixExpression(rewrite, loopVariableName.getIdentifier(), (Expression)getArrayLengthExpression, InfixExpression.Operator.LESS));
        loopStatement.updaters().add(this.getLinkedIncrementExpression(rewrite, loopVariableName.getIdentifier()));
        Block forLoopBody = ast.newBlock();
        forLoopBody.statements().add(ast.newExpressionStatement((Expression)this.getForBodyAssignment(rewrite, loopVariableName)));
        forLoopBody.statements().add(this.createBlankLineStatementWithCursorPosition(rewrite));
        loopStatement.setBody((Statement)forLoopBody);
        rewrite.replace(this.fCurrentNode, (ASTNode)loopStatement, null);
        return rewrite;
    }

    private Assignment getForBodyAssignment(ASTRewrite rewrite, SimpleName loopVariableName) {
        AST ast = rewrite.getAST();
        ITypeBinding loopOverType = this.extractElementType(ast);
        Assignment assignResolvedVariable = ast.newAssignment();
        SimpleName resolvedVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, loopOverType.getName(), loopVariableName.getIdentifier(), false);
        VariableDeclarationFragment resolvedVariableDeclarationFragment = ast.newVariableDeclarationFragment();
        resolvedVariableDeclarationFragment.setName(resolvedVariableName);
        VariableDeclarationExpression resolvedVariableDeclaration = ast.newVariableDeclarationExpression(resolvedVariableDeclarationFragment);
        resolvedVariableDeclaration.setType(this.getImportRewrite().addImport(loopOverType, ast, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(this.fCurrentNode, this.getImportRewrite())));
        assignResolvedVariable.setLeftHandSide((Expression)resolvedVariableDeclaration);
        ArrayAccess access = ast.newArrayAccess();
        access.setArray((Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression));
        SimpleName indexName = ast.newSimpleName(loopVariableName.getIdentifier());
        this.addLinkedPosition(rewrite.track((ASTNode)indexName), -1, indexName.getIdentifier());
        access.setIndex((Expression)indexName);
        assignResolvedVariable.setRightHandSide((Expression)access);
        assignResolvedVariable.setOperator(Assignment.Operator.ASSIGN);
        return assignResolvedVariable;
    }

    private InfixExpression getLinkedInfixExpression(ASTRewrite rewrite, String variableToIncrement, Expression rightHandSide, InfixExpression.Operator operator) {
        AST ast = rewrite.getAST();
        InfixExpression loopExpression = ast.newInfixExpression();
        SimpleName name = ast.newSimpleName(variableToIncrement);
        this.addLinkedPosition(rewrite.track((ASTNode)name), -1, name.getIdentifier());
        loopExpression.setLeftOperand((Expression)name);
        loopExpression.setOperator(operator);
        loopExpression.setRightOperand(rightHandSide);
        return loopExpression;
    }

    private Expression getLinkedIncrementExpression(ASTRewrite rewrite, String variableToIncrement) {
        AST ast = rewrite.getAST();
        PostfixExpression incrementLoopVariable = ast.newPostfixExpression();
        SimpleName name = ast.newSimpleName(variableToIncrement);
        this.addLinkedPosition(rewrite.track((ASTNode)name), -1, name.getIdentifier());
        incrementLoopVariable.setOperand((Expression)name);
        incrementLoopVariable.setOperator(PostfixExpression.Operator.INCREMENT);
        return incrementLoopVariable;
    }

    private VariableDeclarationExpression getForInitializer(AST ast, SimpleName loopVariableName) {
        VariableDeclarationFragment firstDeclarationFragment = ast.newVariableDeclarationFragment();
        firstDeclarationFragment.setName(loopVariableName);
        NumberLiteral startIndex = ast.newNumberLiteral();
        firstDeclarationFragment.setInitializer((Expression)startIndex);
        VariableDeclarationExpression variableDeclaration = ast.newVariableDeclarationExpression(firstDeclarationFragment);
        PrimitiveType variableType = ast.newPrimitiveType(PrimitiveType.INT);
        variableDeclaration.setType((Type)variableType);
        return variableDeclaration;
    }

    private ASTRewrite generateIndexBasedForRewrite(AST ast) {
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ForStatement loopStatement = ast.newForStatement();
        SimpleName loopVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, "int", null, true);
        loopStatement.initializers().add(this.getForInitializer(ast, loopVariableName));
        MethodInvocation listSizeExpression = ast.newMethodInvocation();
        listSizeExpression.setName(ast.newSimpleName("size"));
        Expression listExpression = (Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression);
        listSizeExpression.setExpression(listExpression);
        loopStatement.setExpression((Expression)this.getLinkedInfixExpression(rewrite, loopVariableName.getIdentifier(), (Expression)listSizeExpression, InfixExpression.Operator.LESS));
        loopStatement.updaters().add(this.getLinkedIncrementExpression(rewrite, loopVariableName.getIdentifier()));
        Block forLoopBody = ast.newBlock();
        forLoopBody.statements().add(ast.newExpressionStatement(this.getIndexBasedForBodyAssignment(rewrite, loopVariableName)));
        forLoopBody.statements().add(this.createBlankLineStatementWithCursorPosition(rewrite));
        loopStatement.setBody((Statement)forLoopBody);
        rewrite.replace(this.fCurrentNode, (ASTNode)loopStatement, null);
        return rewrite;
    }

    private Expression getIndexBasedForBodyAssignment(ASTRewrite rewrite, SimpleName loopVariableName) {
        AST ast = rewrite.getAST();
        ITypeBinding loopOverType = this.extractElementType(ast);
        Assignment assignResolvedVariable = ast.newAssignment();
        SimpleName resolvedVariableName = this.resolveLinkedVariableNameWithProposals(rewrite, loopOverType.getName(), loopVariableName.getIdentifier(), false);
        VariableDeclarationFragment resolvedVariableDeclarationFragment = ast.newVariableDeclarationFragment();
        resolvedVariableDeclarationFragment.setName(resolvedVariableName);
        VariableDeclarationExpression resolvedVariableDeclaration = ast.newVariableDeclarationExpression(resolvedVariableDeclarationFragment);
        resolvedVariableDeclaration.setType(this.getImportRewrite().addImport(loopOverType, ast, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(this.fCurrentNode, this.getImportRewrite())));
        assignResolvedVariable.setLeftHandSide((Expression)resolvedVariableDeclaration);
        MethodInvocation invokeGetExpression = ast.newMethodInvocation();
        invokeGetExpression.setName(ast.newSimpleName("get"));
        SimpleName indexVariableName = ast.newSimpleName(loopVariableName.getIdentifier());
        this.addLinkedPosition(rewrite.track((ASTNode)indexVariableName), -1, indexVariableName.getIdentifier());
        invokeGetExpression.arguments().add(indexVariableName);
        invokeGetExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.fCurrentExpression));
        assignResolvedVariable.setRightHandSide((Expression)invokeGetExpression);
        assignResolvedVariable.setOperator(Assignment.Operator.ASSIGN);
        return assignResolvedVariable;
    }

    private SimpleName resolveLinkedVariableNameWithProposals(ASTRewrite rewrite, String basename, String excludedName, boolean firstLinkedProposal) {
        AST ast = rewrite.getAST();
        String[] nameProposals = this.getVariableNameProposals(basename, excludedName);
        SimpleName forDeclarationName = ast.newSimpleName(nameProposals.length > 0 ? nameProposals[0] : basename);
        int i = 0;
        while (i < nameProposals.length) {
            this.addLinkedPositionProposal(forDeclarationName.getIdentifier(), nameProposals[i], null);
            ++i;
        }
        this.addLinkedPosition(rewrite.track((ASTNode)forDeclarationName), firstLinkedProposal, forDeclarationName.getIdentifier());
        return forDeclarationName;
    }

    private Statement createBlankLineStatementWithCursorPosition(ASTRewrite rewrite) {
        Statement blankLineStatement = (Statement)rewrite.createStringPlaceholder("", 20);
        this.setEndPosition(rewrite.track((ASTNode)blankLineStatement));
        return blankLineStatement;
    }

    private String[] getVariableNameProposals(String basename, String excludedName) {
        ASTNode surroundingBlock = this.fCurrentNode;
        while ((surroundingBlock = surroundingBlock.getParent()) != null) {
            if (surroundingBlock instanceof Block) break;
        }
        Collection<String> localUsedNames = new ScopeAnalyzer((CompilationUnit)this.fCurrentExpression.getRoot()).getUsedVariableNames(surroundingBlock.getStartPosition(), surroundingBlock.getLength());
        if (excludedName != null) {
            localUsedNames.add(excludedName);
        }
        String[] names = StubUtility.getLocalNameSuggestions(this.getCompilationUnit().getJavaProject(), basename, 0, localUsedNames.toArray(new String[localUsedNames.size()]));
        return names;
    }

    private ITypeBinding extractElementType(AST ast) {
        if (this.fExpressionType.isArray()) {
            return Bindings.normalizeForDeclarationUse(this.fExpressionType.getElementType(), ast);
        }
        IMethodBinding iteratorMethodBinding = Bindings.findMethodInHierarchy(this.fExpressionType, "iterator", new ITypeBinding[0]);
        IMethodBinding iteratorNextMethodBinding = Bindings.findMethodInHierarchy(iteratorMethodBinding.getReturnType(), "next", new ITypeBinding[0]);
        ITypeBinding currentElementBinding = iteratorNextMethodBinding.getReturnType();
        return Bindings.normalizeForDeclarationUse(currentElementBinding, ast);
    }
}

