/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.breadcrumb;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbItem;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.BreadcrumbViewer;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.IBreadcrumb;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class EditorBreadcrumb
implements IBreadcrumb {
    private static final String ACTIVE_TAB_BG_END = "org.eclipse.ui.workbench.ACTIVE_TAB_BG_END";
    private ITextEditor fTextEditor;
    private ITextViewer fTextViewer;
    private BreadcrumbViewer fBreadcrumbViewer;
    private boolean fHasFocus;
    private boolean fIsActive;
    private Composite fComposite;
    private Listener fDisplayFocusListener;
    private Listener fDisplayKeyListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private ISelection fOldTextSelection;
    private IPartListener fPartListener;

    public EditorBreadcrumb(ITextEditor editor) {
        this.setTextEditor(editor);
    }

    protected abstract Object getCurrentInput();

    protected abstract BreadcrumbViewer createViewer(Composite var1);

    protected abstract boolean reveal(Object var1);

    protected abstract boolean open(Object var1);

    protected abstract ActionGroup createContextMenuActionGroup(ISelectionProvider var1);

    protected abstract void activateBreadcrumb();

    protected abstract void deactivateBreadcrumb();

    public ISelectionProvider getSelectionProvider() {
        return this.fBreadcrumbViewer;
    }

    protected void setTextViewer(ITextViewer viewer) {
        this.fTextViewer = viewer;
    }

    public void setInput(Object element) {
        if (element == null) {
            return;
        }
        Object input = this.fBreadcrumbViewer.getInput();
        if (input == element || element.equals(input)) {
            return;
        }
        if (this.fBreadcrumbViewer.isDropDownOpen()) {
            return;
        }
        this.fBreadcrumbViewer.setInput(element);
    }

    public void activate() {
        if (this.fBreadcrumbViewer.getSelection().isEmpty()) {
            this.fBreadcrumbViewer.setSelection((ISelection)new StructuredSelection(this.fBreadcrumbViewer.getInput()));
        }
        this.fBreadcrumbViewer.setFocus();
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public Control createContent(Composite parent) {
        Assert.isTrue((this.fComposite == null ? 1 : 0) != 0, (String)"Content must only be created once.");
        boolean rtl = (this.getTextEditor().getSite().getShell().getStyle() & 0x4000000) != 0;
        this.fComposite = new Composite(parent, rtl ? 0x4000000 : 0);
        GridData data = new GridData(4, 128, true, false);
        this.fComposite.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fComposite.setLayout((Layout)gridLayout);
        this.fDisplayFocusListener = new Listener(){

            public void handleEvent(Event event) {
                if (EditorBreadcrumb.this.isBreadcrumbEvent(event)) {
                    if (EditorBreadcrumb.this.fHasFocus) {
                        return;
                    }
                    EditorBreadcrumb.this.fIsActive = true;
                    EditorBreadcrumb.this.focusGained();
                } else {
                    if (!EditorBreadcrumb.this.fIsActive) {
                        return;
                    }
                    boolean hasTextFocus = EditorBreadcrumb.this.fTextViewer.getTextWidget().isFocusControl();
                    if (hasTextFocus) {
                        EditorBreadcrumb.this.fIsActive = false;
                    }
                    if (!EditorBreadcrumb.this.fHasFocus) {
                        return;
                    }
                    EditorBreadcrumb.this.focusLost();
                }
            }
        };
        Display.getCurrent().addFilter(15, this.fDisplayFocusListener);
        this.fBreadcrumbViewer = this.createViewer(this.fComposite);
        this.fBreadcrumbViewer.getControl().setBackground(Display.getDefault().getSystemColor(1));
        this.fBreadcrumbViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element == null) {
                    return;
                }
                BreadcrumbItem item = (BreadcrumbItem)EditorBreadcrumb.this.fBreadcrumbViewer.doFindItem(element);
                if (item == null) {
                    return;
                }
                int index = EditorBreadcrumb.this.fBreadcrumbViewer.getIndexOfItem(item);
                BreadcrumbItem parentItem = EditorBreadcrumb.this.fBreadcrumbViewer.getItem(index - 1);
                parentItem.openDropDownMenu();
            }
        });
        this.fBreadcrumbViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                EditorBreadcrumb.this.doRevealOrOpen(event.getSelection());
            }
        });
        this.fBreadcrumbViewer.addMenuDetectListener(new MenuDetectListener(){

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void menuDetected(MenuDetectEvent event) {
                BreadcrumbViewer selectionProvider = EditorBreadcrumb.this.fBreadcrumbViewer.isDropDownOpen() ? EditorBreadcrumb.this.fBreadcrumbViewer.getDropDownSelectionProvider() : EditorBreadcrumb.this.fBreadcrumbViewer;
                ActionGroup actionGroup = EditorBreadcrumb.this.createContextMenuActionGroup((ISelectionProvider)selectionProvider);
                if (actionGroup == null) {
                    return;
                }
                try {
                    block10: {
                        Menu menu;
                        block9: {
                            MenuManager manager = new MenuManager();
                            actionGroup.setContext(new ActionContext(selectionProvider.getSelection()));
                            actionGroup.fillContextMenu((IMenuManager)manager);
                            EditorBreadcrumb.this.getTextEditor().getEditorSite().registerContextMenu(manager, (ISelectionProvider)selectionProvider, false);
                            if (manager.isEmpty()) {
                                return;
                            }
                            menu = manager.createContextMenu(EditorBreadcrumb.this.fBreadcrumbViewer.getControl());
                            menu.setLocation(event.x + 10, event.y + 10);
                            menu.setVisible(true);
                            if (!true) break block9;
                            if (menu.isDisposed()) return;
                            if (!menu.isVisible()) break block10;
                        }
                        do {
                            if (!menu.getDisplay().readAndDispatch()) {
                                menu.getDisplay().sleep();
                            }
                            if (menu.isDisposed()) return;
                        } while (menu.isVisible());
                    }
                    return;
                }
                finally {
                    actionGroup.dispose();
                }
            }
        });
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (EditorBreadcrumb.ACTIVE_TAB_BG_END.equals(event.getProperty()) && EditorBreadcrumb.this.fComposite.isFocusControl()) {
                    EditorBreadcrumb.this.fComposite.setBackground(JFaceResources.getColorRegistry().get(EditorBreadcrumb.ACTIVE_TAB_BG_END));
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.fPropertyChangeListener);
        return this.fComposite;
    }

    public void dispose() {
        if (this.fPropertyChangeListener != null) {
            JFaceResources.getColorRegistry().removeListener(this.fPropertyChangeListener);
        }
        if (this.fDisplayFocusListener != null) {
            Display.getDefault().removeFilter(15, this.fDisplayFocusListener);
        }
        this.deinstallDisplayListeners();
        if (this.fPartListener != null) {
            this.getTextEditor().getSite().getPage().removePartListener(this.fPartListener);
        }
        this.setTextEditor(null);
    }

    private void doRevealOrOpen(ISelection selection) {
        if (this.doReveal(selection)) {
            this.fTextViewer.getTextWidget().setFocus();
        } else if (this.doOpen(selection)) {
            this.fIsActive = false;
            this.focusLost();
            this.fBreadcrumbViewer.setInput(this.getCurrentInput());
        }
    }

    private boolean doOpen(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return false;
        }
        return this.open(structuredSelection.getFirstElement());
    }

    private boolean doReveal(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            return false;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        if (structuredSelection.isEmpty()) {
            return false;
        }
        if (this.fOldTextSelection != null) {
            this.getTextEditor().getSelectionProvider().setSelection(this.fOldTextSelection);
            boolean result = this.reveal(structuredSelection.getFirstElement());
            this.fOldTextSelection = this.getTextEditor().getSelectionProvider().getSelection();
            this.getTextEditor().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this));
            return result;
        }
        return this.reveal(structuredSelection.getFirstElement());
    }

    private void focusGained() {
        if (this.fHasFocus) {
            this.focusLost();
        }
        this.fComposite.setBackground(JFaceResources.getColorRegistry().get(ACTIVE_TAB_BG_END));
        this.fHasFocus = true;
        this.installDisplayListeners();
        this.activateBreadcrumb();
        this.getTextEditor().getEditorSite().getActionBars().updateActionBars();
        this.fOldTextSelection = this.getTextEditor().getSelectionProvider().getSelection();
        this.getTextEditor().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this));
    }

    private void focusLost() {
        if (!this.fHasFocus) {
            return;
        }
        this.fComposite.setBackground(null);
        this.fHasFocus = false;
        this.deinstallDisplayListeners();
        this.deactivateBreadcrumb();
        this.getTextEditor().getEditorSite().getActionBars().updateActionBars();
        this.getTextEditor().getSelectionProvider().setSelection(this.fOldTextSelection);
        this.fOldTextSelection = null;
    }

    private void installDisplayListeners() {
        this.deinstallDisplayListeners();
        this.fDisplayKeyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode != 27) {
                    return;
                }
                if (!EditorBreadcrumb.this.isBreadcrumbEvent(event)) {
                    return;
                }
                EditorBreadcrumb.this.fTextViewer.getTextWidget().setFocus();
            }
        };
        Display.getDefault().addFilter(1, this.fDisplayKeyListener);
    }

    private void deinstallDisplayListeners() {
        if (this.fDisplayKeyListener != null) {
            Display.getDefault().removeFilter(1, this.fDisplayKeyListener);
            this.fDisplayKeyListener = null;
        }
    }

    private boolean isBreadcrumbEvent(Event event) {
        if (this.fBreadcrumbViewer == null) {
            return false;
        }
        Widget item = event.widget;
        if (!(item instanceof Control)) {
            return false;
        }
        Shell dropDownShell = this.fBreadcrumbViewer.getDropDownShell();
        if (dropDownShell != null && this.isChild((Control)item, (Control)dropDownShell)) {
            return true;
        }
        return this.isChild((Control)item, this.fBreadcrumbViewer.getControl());
    }

    private boolean isChild(Control child, Control parent) {
        if (child == null) {
            return false;
        }
        if (child == parent) {
            return true;
        }
        return this.isChild((Control)child.getParent(), parent);
    }

    protected void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
        if (this.fTextEditor == null) {
            return;
        }
        this.fPartListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part == EditorBreadcrumb.this.fTextEditor && EditorBreadcrumb.this.fHasFocus) {
                    EditorBreadcrumb.this.focusGained();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part == EditorBreadcrumb.this.fTextEditor && EditorBreadcrumb.this.fHasFocus) {
                    EditorBreadcrumb.this.focusLost();
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.fTextEditor.getSite().getPage().addPartListener(this.fPartListener);
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }
}

