/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractLocalDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractTempRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_FINAL = "final";
    private CompilationUnit fCompilationUnitNode;
    private CompilationUnitRewrite fCURewrite;
    private ICompilationUnit fCu;
    private boolean fDeclareFinal;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private IExpressionFragment fSelectedExpression;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private String[] fGuessedTempNames;
    private boolean fCheckResultForCompileProblems;
    private CompilationUnitChange fChange;
    private LinkedProposalModel fLinkedProposalModel;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";

    private static boolean allArraysEqual(Object[][] arrays, int position) {
        Object element = arrays[0][position];
        int i = 0;
        while (i < arrays.length) {
            Object[] array = arrays[i];
            if (!element.equals(array[position])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private static Object[] getArrayPrefix(Object[] array, int prefixLength) {
        Assert.isTrue((prefixLength <= array.length ? 1 : 0) != 0);
        Assert.isTrue((prefixLength >= 0 ? 1 : 0) != 0);
        Object[] prefix = new Object[prefixLength];
        int i = 0;
        while (i < prefix.length) {
            prefix[i] = array[i];
            ++i;
        }
        return prefix;
    }

    private static List<IVariableBinding> getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private static Object[] getLongestArrayPrefix(Object[][] arrays) {
        int length = -1;
        if (arrays.length == 0) {
            return new Object[0];
        }
        int minArrayLength = arrays[0].length;
        int i = 1;
        while (i < arrays.length) {
            minArrayLength = Math.min(minArrayLength, arrays[i].length);
            ++i;
        }
        i = 0;
        while (i < minArrayLength) {
            if (!ExtractTempRefactoring.allArraysEqual(arrays, i)) break;
            ++length;
            ++i;
        }
        if (length == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(arrays[0], length + 1);
    }

    private static ASTNode[] getParents(ASTNode node) {
        ASTNode current = node;
        ArrayList<ASTNode> parents = new ArrayList<ASTNode>();
        do {
            parents.add(current.getParent());
        } while ((current = current.getParent()).getParent() != null);
        Collections.reverse(parents);
        return parents.toArray(new ASTNode[parents.size()]);
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List<IVariableBinding> forInitializerVariables = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractTempRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    public ExtractTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCompilationUnitNode = null;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
        this.fCheckResultForCompileProblems = true;
    }

    public ExtractTempRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(astRoot.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = (ICompilationUnit)astRoot.getTypeRoot();
        this.fCompilationUnitNode = astRoot;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
        this.fCheckResultForCompileProblems = true;
    }

    public ExtractTempRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public void setCheckResultForCompileProblems(boolean checkResultForCompileProblems) {
        this.fCheckResultForCompileProblems = checkResultForCompileProblems;
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    private void addReplaceExpressionWithTemp() throws JavaModelException {
        IASTFragment[] fragmentsToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        HashSet<IASTFragment> seen = new HashSet<IASTFragment>();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (seen.add(fragment)) {
                SimpleName tempName = this.fCURewrite.getAST().newSimpleName(this.fTempName);
                TextEditGroup description = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_replace);
                fragment.replace(rewrite, (ASTNode)tempName, description);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)tempName), false);
                }
            }
            ++i;
        }
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression != null) {
            ASTNode parent = selectedExpression.getParent();
            if (selectedExpression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (selectedExpression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (selectedExpression instanceof Assignment) {
                if (parent instanceof Expression && !(parent instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (selectedExpression instanceof SimpleName) {
                if (((SimpleName)selectedExpression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (parent instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || parent instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            } else if (selectedExpression instanceof VariableDeclarationExpression && parent instanceof TryStatement) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_resource_in_try_with_resources);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: 
            case 3: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private ITypeBinding guessBindingForReference(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null) {
            binding = ASTResolving.guessBindingForReference((ASTNode)expression);
        }
        return binding;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 4);
            this.fCURewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
            this.fCURewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            this.doCreateChange((IProgressMonitor)new SubProgressMonitor(pm, 2));
            this.fChange = this.fCURewrite.createChange(RefactoringCoreMessages.ExtractTempRefactoring_change_name, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            RefactoringStatus result = new RefactoringStatus();
            if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
                result.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, BasicElementLabels.getJavaElementName(this.fTempName)));
            }
            result.merge(this.checkMatchingFragments());
            this.fChange.setKeepPreviewEdits(true);
            if (this.fCheckResultForCompileProblems) {
                this.checkNewSource(new SubProgressMonitor(pm, 1), result);
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private final ExtractLocalDescriptor createRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fTempName));
        String expression = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String header = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.fTempName), BasicElementLabels.getJavaCodeString(expression)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, BasicElementLabels.getJavaElementName(this.fTempName)));
        BodyDeclaration decl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression.getAssociatedExpression(), BodyDeclaration.class);
        if (decl instanceof MethodDeclaration) {
            IMethodBinding method = ((MethodDeclaration)decl).resolveBinding();
            String label = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : BasicElementLabels.getJavaElementName("{...}");
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_destination_pattern, label));
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, BasicElementLabels.getJavaCodeString(expression)));
        if (this.fReplaceAllOccurrences) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_final);
        }
        ExtractLocalDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractLocalDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)0);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
        arguments.put(KEY_NAME, this.fTempName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        return descriptor;
    }

    private void doCreateChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            try {
                this.createTempDeclaration();
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
            this.addReplaceExpressionWithTemp();
        }
        finally {
            pm.done();
        }
    }

    private void checkNewSource(SubProgressMonitor monitor, RefactoringStatus result) throws CoreException {
        String newCuSource = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCUNode = new RefactoringASTParser(8).parse(newCuSource, this.fCu, true, true, (IProgressMonitor)monitor);
        IProblem[] newProblems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, this.fCompilationUnitNode);
        int i = 0;
        while (i < newProblems.length) {
            IProblem problem = newProblems[i];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, SourceRangeFactory.create(problem))));
            }
            ++i;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 6);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fCompilationUnitNode == null) {
                this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            result.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (!result.hasFatalError() && this.isLiteralNodeSelected()) {
                this.fReplaceAllOccurrences = false;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        int i = 0;
        while (i < matchingFragments.length) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(node) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create((ITypeRoot)this.fCu, node));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        try {
            pm.beginTask("", 8);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (this.getEnclosingBodyNode() == null || ASTNodes.getParent(associatedNode, Annotation.class) != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                return refactoringStatus;
            }
            pm.worked(1);
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionFragmentIsRValue());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkTempName(String newName) {
        RefactoringStatus status = Checks.checkTempName(newName, (IJavaElement)this.fCu);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(newName)) {
            status.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, BasicElementLabels.getJavaElementName(newName)));
        }
        return status;
    }

    private void createAndInsertTempDeclaration() throws CoreException {
        Expression initializer = this.getSelectedExpression().createCopyTarget(this.fCURewrite.getASTRewrite(), true);
        VariableDeclarationStatement vds = this.createTempDeclaration(initializer);
        if (!this.fReplaceAllOccurrences || ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments()).length <= 1) {
            this.insertAt(this.getSelectedExpression().getAssociatedNode(), (Statement)vds);
            return;
        }
        ASTNode[] firstReplaceNodeParents = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] commonPath = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue((commonPath.length <= firstReplaceNodeParents.length ? 1 : 0) != 0);
        ASTNode deepestCommonParent = firstReplaceNodeParents[commonPath.length - 1];
        if (deepestCommonParent instanceof Block) {
            this.insertAt(firstReplaceNodeParents[commonPath.length], (Statement)vds);
        } else {
            this.insertAt(deepestCommonParent, (Statement)vds);
        }
    }

    private VariableDeclarationStatement createTempDeclaration(Expression initializer) throws CoreException {
        AST ast = this.fCURewrite.getAST();
        VariableDeclarationFragment vdf = ast.newVariableDeclarationFragment();
        vdf.setName(ast.newSimpleName(this.fTempName));
        vdf.setInitializer(initializer);
        VariableDeclarationStatement vds = ast.newVariableDeclarationStatement(vdf);
        if (this.fDeclareFinal) {
            vds.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        }
        vds.setType(this.createTempType());
        if (this.fLinkedProposalModel != null) {
            ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
            LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(rewrite.track((ASTNode)vdf.getName()), true);
            String[] nameSuggestions = this.guessTempNames();
            if (nameSuggestions.length > 0 && !nameSuggestions[0].equals(this.fTempName)) {
                nameGroup.addProposal(this.fTempName, null, nameSuggestions.length + 1);
            }
            int i = 0;
            while (i < nameSuggestions.length) {
                nameGroup.addProposal(nameSuggestions[i], null, nameSuggestions.length - i);
                ++i;
            }
        }
        return vds;
    }

    private void insertAt(ASTNode target, Statement declaration) {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        TextEditGroup groupDescription = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
        ASTNode parent = target.getParent();
        StructuralPropertyDescriptor locationInParent = target.getLocationInParent();
        while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.STATEMENTS_PROPERTY) {
            if (locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY) {
                Block replacement = rewrite.getAST().newBlock();
                ListRewrite replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)declaration, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
        }
        ListRewrite listRewrite = rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)locationInParent);
        listRewrite.insertBefore((ASTNode)declaration, target, groupDescription);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            ExtractLocalDescriptor descriptor = this.createRefactoringDescriptor();
            this.fChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = this.fChange;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void createTempDeclaration() throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            this.replaceSelectedExpressionWithTempDeclaration();
        } else {
            this.createAndInsertTempDeclaration();
        }
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaModelException {
        ASTNode[] matchNodes = this.getMatchNodes();
        Object[][] matchingNodesParents = new ASTNode[matchNodes.length][];
        int i = 0;
        while (i < matchNodes.length) {
            matchingNodesParents[i] = ExtractTempRefactoring.getParents(matchNodes[i]);
            ++i;
        }
        List<Object> l = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(matchingNodesParents));
        return l.toArray(new ASTNode[l.size()]);
    }

    private Block getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        StructuralPropertyDescriptor location = null;
        while (node != null && !(node instanceof BodyDeclaration)) {
            location = node.getLocationInParent();
            node = node.getParent();
        }
        if (location == MethodDeclaration.BODY_PROPERTY || location == Initializer.BODY_PROPERTY) {
            return (Block)node.getStructuralProperty(location);
        }
        return null;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 18);
                this.fExcludedVariableNames = new String[bindings.length];
                int i = 0;
                while (i < bindings.length) {
                    this.fExcludedVariableNames[i] = bindings[i].getName();
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] nodesToReplace = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (nodesToReplace.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator<IASTFragment> comparator = new Comparator<IASTFragment>(){

            @Override
            public int compare(IASTFragment o1, IASTFragment o2) {
                return o1.getStartPosition() - o2.getStartPosition();
            }
        };
        Arrays.sort(nodesToReplace, comparator);
        return (IExpressionFragment)nodesToReplace[0];
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] allMatches = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return allMatches;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] matches = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] result = new ASTNode[matches.length];
        int i = 0;
        while (i < matches.length) {
            result[i] = matches[i].getAssociatedNode();
            ++i;
        }
        return result;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private Type createTempType() throws CoreException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Type resultingType = null;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        if (expression instanceof ClassInstanceCreation && (typeBinding == null || typeBinding.getTypeArguments().length == 0)) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((ClassInstanceCreation)expression).getType());
        } else if (expression instanceof CastExpression) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((CastExpression)expression).getType());
        } else {
            if (typeBinding == null) {
                typeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (typeBinding != null) {
                typeBinding = Bindings.normalizeForDeclarationUse(typeBinding, ast);
                ImportRewrite importRewrite = this.fCURewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                resultingType = importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context);
            } else {
                resultingType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroup typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            typeGroup.addPosition(rewrite.track((ASTNode)resultingType), false);
            if (typeBinding != null) {
                ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes(ast, typeBinding);
                int i = 0;
                while (i < relaxingTypes.length) {
                    typeGroup.addProposal(relaxingTypes[i], this.fCURewrite.getCu(), relaxingTypes.length - i);
                    ++i;
                }
            }
        }
        return resultingType;
    }

    public String guessTempName() {
        String[] proposals = this.guessTempNames();
        if (proposals.length == 0) {
            return this.fTempName;
        }
        return proposals[0];
    }

    public String[] guessTempNames() {
        if (this.fGuessedTempNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = this.guessBindingForReference(expression);
                    this.fGuessedTempNames = StubUtility.getVariableNameSuggestions(5, this.fCu.getJavaProject(), binding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaModelException javaModelException) {}
            if (this.fGuessedTempNames == null) {
                this.fGuessedTempNames = new String[0];
            }
        }
        return this.fGuessedTempNames;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment fragment = this.getSelectedExpression();
        if (fragment == null) {
            return false;
        }
        Expression expression = fragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, ConstructorInvocation.class) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, SuperConstructorInvocation.class) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    private void replaceSelectedExpressionWithTempDeclaration() throws CoreException {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        Expression initializer = (Expression)rewrite.createMoveTarget((ASTNode)selectedExpression);
        VariableDeclarationStatement replacement = this.createTempDeclaration(initializer);
        ExpressionStatement parent = (ExpressionStatement)selectedExpression.getParent();
        if (ASTNodes.isControlStatementBody(parent.getLocationInParent())) {
            Block block = rewrite.getAST().newBlock();
            block.statements().add(replacement);
            replacement = block;
        }
        rewrite.replace((ASTNode)parent, (ASTNode)replacement, this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable));
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public void setTempName(String newName) {
        this.fTempName = newName;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        return selectedFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(selectedFragment.getAssociatedNode()));
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        IJavaElement element;
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.extract.temp");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String name = arguments.getAttribute(KEY_NAME);
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
        }
        this.fTempName = name;
        String replace = arguments.getAttribute(ATTRIBUTE_REPLACE);
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceAllOccurrences = Boolean.valueOf(replace);
        String declareFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (declareFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fDeclareFinal = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection<IVariableBinding> fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection<IVariableBinding> forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

