/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;

public class DependencyInfoJsonTypeAdapter
implements JsonSerializer<DependencyInfo>,
JsonDeserializer<DependencyInfo> {
    private final Type cacheType = new TypeToken<Map<String, String>>(){}.getType();

    public DependencyInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive fileElement = jsonObject.getAsJsonPrimitive("location");
        File file = new File(fileElement.getAsString());
        JsonElement typeElement = jsonObject.get("type");
        DependencyType type = (DependencyType)context.deserialize(typeElement, DependencyType.class);
        JsonElement hintsElement = jsonObject.get("hints");
        Map hints = (Map)context.deserialize(hintsElement, this.cacheType);
        return new DependencyInfo(file, type, hints);
    }

    public JsonElement serialize(DependencyInfo src, Type typeOfSrc, JsonSerializationContext context) {
        JsonPrimitive file = new JsonPrimitive(src.getFile().getAbsoluteFile().toString());
        JsonElement type = context.serialize((Object)src.getType());
        JsonElement hints = context.serialize((Object)src.getHints());
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("location", (JsonElement)file);
        jsonObject.add("type", type);
        jsonObject.add("hints", hints);
        return jsonObject;
    }
}

