/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.recommenders.internal.models.rcp.AdvisorDescriptor;
import org.eclipse.recommenders.internal.models.rcp.AdvisorDescriptors;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AdvisorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int UP = -1;
    private static final int DOWN = 1;

    public AdvisorsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.models.rcp"));
        this.setMessage(Messages.PREFPAGE_TITLE_ADVISORS);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_ADVISORS);
    }

    protected void createFieldEditors() {
        this.addField(new AdvisorEditor("advisor.list.sorted", Messages.FIELD_LABEL_ADVISORS, this.getFieldEditorParent()));
    }

    private final class AdvisorEditor
    extends FieldEditor {
        private CheckboxTableViewer tableViewer;
        private Composite buttonBox;
        private Button upButton;
        private Button downButton;

        private AdvisorEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridDataFactory.swtDefaults().span(numColumns, 1).applyTo((Control)control);
            this.tableViewer = this.getTableControl(parent);
            GridDataFactory.fillDefaults().align(4, 4).span(numColumns - 1, 1).grab(true, false).applyTo((Control)this.tableViewer.getTable());
            this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AdvisorEditor.this.updateButtonStatus();
                }
            });
            this.buttonBox = this.getButtonControl(parent);
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buttonBox);
        }

        private void updateButtonStatus() {
            int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
            this.upButton.setEnabled(selectionIndex != -1 && selectionIndex > 0);
            this.downButton.setEnabled(selectionIndex != -1 && selectionIndex < this.tableViewer.getTable().getItemCount() - 1);
        }

        private Composite getButtonControl(Composite parent) {
            Composite box = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(box);
            this.upButton = this.createUpDownButton(box, Messages.BUTTON_LABEL_UP, -1);
            this.downButton = this.createUpDownButton(box, Messages.BUTTON_LABEL_DOWN, 1);
            return box;
        }

        private Button createUpDownButton(Composite box, String text, int mode) {
            Button button = new Button(box, 8);
            button.setText(text);
            button.setEnabled(false);
            button.addSelectionListener((SelectionListener)new MoveSelectionListener(mode));
            int widthHint = Math.max(this.convertHorizontalDLUsToPixels((Control)button, 61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)button);
            return button;
        }

        private CheckboxTableViewer getTableControl(Composite parent) {
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
            tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    AdvisorDescriptor descriptor = (AdvisorDescriptor)Checks.cast((Object)element);
                    return descriptor.getName();
                }

                public String getToolTipText(Object element) {
                    AdvisorDescriptor descriptor = (AdvisorDescriptor)Checks.cast((Object)element);
                    return descriptor.getDescription();
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            return tableViewer;
        }

        protected void doLoad() {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.load(value);
        }

        private void load(String value) {
            List<AdvisorDescriptor> input = AdvisorDescriptors.load(value, AdvisorDescriptors.getRegisteredAdvisors());
            ArrayList checkedElements = Lists.newArrayList();
            for (AdvisorDescriptor descriptor : input) {
                if (!descriptor.isEnabled()) continue;
                checkedElements.add(descriptor);
            }
            this.tableViewer.setInput(input);
            this.tableViewer.setCheckedElements(checkedElements.toArray());
        }

        protected void doLoadDefault() {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.load(value);
        }

        protected void doStore() {
            List descriptors = (List)Checks.cast((Object)this.tableViewer.getInput());
            for (AdvisorDescriptor descriptor : descriptors) {
                descriptor.setEnabled(this.tableViewer.getChecked((Object)descriptor));
            }
            String newValue = AdvisorDescriptors.store(descriptors);
            this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
        }

        public int getNumberOfControls() {
            return 2;
        }

        private final class MoveSelectionListener
        extends SelectionAdapter {
            private final int direction;

            public MoveSelectionListener(int direction) {
                this.direction = direction;
            }

            public void widgetSelected(SelectionEvent e) {
                List input = (List)Checks.cast((Object)AdvisorEditor.this.tableViewer.getInput());
                int index = AdvisorEditor.this.tableViewer.getTable().getSelectionIndex();
                AdvisorDescriptor movedElement = (AdvisorDescriptor)input.remove(index);
                int newIndex = Math.min(Math.max(0, index + this.direction), input.size());
                input.add(newIndex, movedElement);
                AdvisorEditor.this.tableViewer.setInput((Object)input);
                AdvisorEditor.this.updateButtonStatus();
            }
        }
    }
}

