/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.proposals;

import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.ProposalProcessorManager;
import org.eclipse.recommenders.internal.completion.rcp.IProcessableProposalFactory;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableAnonymousTypeCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableFilledArgumentNamesMethodProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableGetterSetterCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableJavaCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableJavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableJavaMethodCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableLazyGenericTypeProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableLazyJavaTypeCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableMethodDeclarationCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableOverrideCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableParameterGuessingProposal;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class ProcessableProposalFactory
implements IProcessableProposalFactory {
    @Inject
    public ProcessableProposalFactory() {
    }

    public static IJavaCompletionProposal create(CompletionProposal coreProposal, IJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context, IProcessableProposalFactory factory) {
        Class<?> c = uiProposal.getClass();
        try {
            if (JavaMethodCompletionProposal.class == c) {
                return factory.newJavaMethodCompletionProposal(coreProposal, context);
            }
            if (JavaFieldWithCastedReceiverCompletionProposal.class == c) {
                return factory.newJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaFieldWithCastedReceiverCompletionProposal)uiProposal, context);
            }
            if (OverrideCompletionProposal.class == c) {
                return factory.newOverrideCompletionProposal(coreProposal, (OverrideCompletionProposal)uiProposal, context);
            }
            if (AnonymousTypeCompletionProposal.class == c) {
                return factory.newAnonymousTypeCompletionProposal(coreProposal, (AnonymousTypeCompletionProposal)uiProposal, context);
            }
            if (JavaCompletionProposal.class == c) {
                return factory.newJavaCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context);
            }
            if (LazyGenericTypeProposal.class == c) {
                return factory.newLazyGenericTypeProposal(coreProposal, context);
            }
            if (LazyJavaTypeCompletionProposal.class == c) {
                return factory.newLazyJavaTypeCompletionProposal(coreProposal, context);
            }
            if (FilledArgumentNamesMethodProposal.class == c) {
                return factory.newFilledArgumentNamesMethodProposal(coreProposal, context);
            }
            if (ParameterGuessingProposal.class == c) {
                return factory.newParameterGuessingProposal(coreProposal, context);
            }
            if (MethodDeclarationCompletionProposal.class == c) {
                return factory.newMethodDeclarationCompletionProposal(coreProposal, (MethodDeclarationCompletionProposal)uiProposal, context);
            }
            if (GetterSetterCompletionProposal.class == c) {
                return factory.newGetterSetterCompletionProposal(coreProposal, (GetterSetterCompletionProposal)uiProposal, context);
            }
            RecommendersUtilsPlugin.logWarning((String)"Unknown JDT proposal type '%s' ('%s'). Returning original proposal instead.", (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
        catch (Exception e) {
            RecommendersUtilsPlugin.logWarning((Exception)e, (String)"Wrapping JDT proposal '%s' ('%s') failed. Returning original proposal instead.", (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
    }

    @Override
    public IProcessableProposal newLazyGenericTypeProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyGenericTypeProposal(coreProposal, context));
    }

    protected IProcessableProposal postConstruct(IProcessableProposal res) {
        res.setProposalProcessorManager(new ProposalProcessorManager(res));
        return res;
    }

    @Override
    public IProcessableProposal newFilledArgumentNamesMethodProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableFilledArgumentNamesMethodProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newParameterGuessingProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        boolean fillBestGuess = this.shouldFillArgumentNames();
        return this.postConstruct(new ProcessableParameterGuessingProposal(coreProposal, context, fillBestGuess));
    }

    private boolean shouldFillArgumentNames() {
        try {
            boolean res = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_guess_method_arguments");
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public IProcessableProposal newAnonymousTypeCompletionProposal(CompletionProposal coreProposal, AnonymousTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        return this.postConstruct(new ProcessableAnonymousTypeCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
    }

    @Override
    public IProcessableProposal newJavaFieldWithCastedReceiverCompletionProposal(CompletionProposal coreProposal, JavaFieldWithCastedReceiverCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavaCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaCompletionProposal(coreProposal, uiProposal, context));
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavaMethodCompletionProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableJavaMethodCompletionProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newLazyJavaTypeCompletionProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyJavaTypeCompletionProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newOverrideCompletionProposal(CompletionProposal coreProposal, OverrideCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableOverrideCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
    }

    @Override
    public IProcessableProposal newMethodDeclarationCompletionProposal(CompletionProposal coreProposal, MethodDeclarationCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IType type = (IType)context.getCoreContext().getEnclosingElement();
            if (type != null) {
                return this.postConstruct(ProcessableMethodDeclarationCompletionProposal.newProposal(coreProposal, type, uiProposal.getRelevance()));
            }
        }
        catch (CoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
        throw Throws.throwIllegalArgumentException((String)"no type found");
    }

    @Override
    public IJavaCompletionProposal newGetterSetterCompletionProposal(CompletionProposal coreProposal, GetterSetterCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IField field = (IField)uiProposal.getJavaElement();
            return this.postConstruct(new ProcessableGetterSetterCompletionProposal(coreProposal, field, uiProposal.getDisplayString().startsWith("get"), uiProposal.getRelevance()));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

