/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.ProposalProcessor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;

public class ProposalProcessorManager {
    private final Set<ProposalProcessor> processors = Sets.newLinkedHashSet();
    private final IProcessableProposal proposal;
    private final StyledString orgDisplayString;
    private final int orgRelevance;

    public ProposalProcessorManager(IProcessableProposal proposal) {
        this.proposal = proposal;
        this.orgRelevance = proposal.getRelevance();
        this.orgDisplayString = ProposalProcessorManager.deepCopy(proposal.getStyledDisplayString());
    }

    public void addProcessor(ProposalProcessor processor) {
        this.processors.add(processor);
    }

    public boolean prefixChanged(String prefix) {
        boolean keepProposal = false;
        StyledString tmpStyledString = ProposalProcessorManager.deepCopy(this.orgDisplayString);
        int tmpRelevance = 0;
        for (ProposalProcessor p : this.processors) {
            keepProposal |= p.isPrefix(prefix);
            p.modifyDisplayString(tmpStyledString);
            tmpRelevance += p.modifyRelevance();
        }
        this.proposal.setRelevance(tmpRelevance);
        this.proposal.setStyledDisplayString(tmpStyledString);
        return keepProposal;
    }

    public static StyledString deepCopy(StyledString displayString) {
        StyledString copy = new StyledString(displayString.getString());
        StyleRange[] styleRangeArray = displayString.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final StyleRange range = styleRangeArray[n2];
            copy.setStyle(range.start, range.length, new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.background = range.background;
                    textStyle.borderColor = range.borderColor;
                    textStyle.borderStyle = range.borderStyle;
                    textStyle.font = range.font;
                    textStyle.foreground = range.foreground;
                }
            });
            ++n2;
        }
        return copy;
    }
}

