/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.parser.VersionParserFactory;

public class VersionRange {
    public static final VersionRange EMPTY = new VersionRangeBuilder().minExclusive(Version.ZERO).maxExclusive(Version.ZERO).build();
    public static VersionRange ALL = new VersionRangeBuilder().minInclusive(Version.UNKNOWN).maxInclusive(Version.LATEST).build();
    private Version minVersion;
    private boolean minVersionInclusive;
    private Version maxVersion;
    private boolean maxVersionInclusive;

    protected VersionRange() {
    }

    public VersionRange(Version minVersion, boolean minVersionInclusive, Version maxVersion, boolean maxVersionInclusive) {
        this.minVersion = minVersion;
        this.minVersionInclusive = minVersionInclusive;
        this.maxVersion = maxVersion;
        this.maxVersionInclusive = maxVersionInclusive;
    }

    public boolean isIncluded(Version version) {
        int maxCheck;
        Checks.ensureIsNotNull(version);
        int minCheck = this.isMinVersionInclusive() ? 0 : 1;
        int n = maxCheck = this.isMaxVersionInclusive() ? 0 : -1;
        return version.compareTo(this.getMinVersion()) >= minCheck && version.compareTo(this.getMaxVersion()) <= maxCheck;
    }

    public boolean hasGreaterEqualUpperBoundThan(VersionRange versionRange) {
        Checks.ensureIsNotNull(versionRange);
        int versionCompare = versionRange.getMaxVersion().compareTo(this.getMaxVersion());
        if (versionCompare != 0) {
            return versionCompare < 0;
        }
        return this.isMaxVersionInclusive() || !versionRange.isMaxVersionInclusive();
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public boolean isMinVersionInclusive() {
        return this.minVersionInclusive;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isMaxVersionInclusive() {
        return this.maxVersionInclusive;
    }

    public String toString() {
        String lowerBoundCharacter = this.isMinVersionInclusive() ? "[" : "(";
        String upperBoundCharacter = this.isMaxVersionInclusive() ? "]" : ")";
        return String.format("%s%s,%s%s", lowerBoundCharacter, this.getMinVersion(), this.getMaxVersion(), upperBoundCharacter);
    }

    public boolean isVersionBelow(Version version) {
        int compare = this.minVersion.compareTo(version);
        if (compare == 0) {
            return !this.isMinVersionInclusive();
        }
        return compare > 0;
    }

    public boolean isVersionAbove(Version version) {
        int compare = this.maxVersion.compareTo(version);
        if (compare == 0) {
            return !this.isMaxVersionInclusive();
        }
        return compare < 0;
    }

    public boolean isUpperBoundHigherThan(VersionRange range) {
        int cmp = this.getMaxVersion().compareTo(range.getMaxVersion());
        if (cmp == 0) {
            return this.isMaxVersionInclusive() && !range.isMaxVersionInclusive();
        }
        return cmp > 0;
    }

    public boolean isLowerBoundLowerThan(VersionRange range) {
        int cmp = this.getMinVersion().compareTo(range.getMinVersion());
        if (cmp == 0) {
            return this.isMinVersionInclusive() && !range.isMinVersionInclusive();
        }
        return cmp < 0;
    }

    public boolean isUpperBoundEquals(VersionRange range) {
        return this.isMaxVersionInclusive() == range.isMaxVersionInclusive() && this.getMaxVersion().equals(range.getMaxVersion());
    }

    public boolean isLowerBoundEquals(VersionRange range) {
        return this.isMinVersionInclusive() == range.isMinVersionInclusive() && this.getMinVersion().equals(range.getMinVersion());
    }

    public boolean isEmpty() {
        int compare = this.getMinVersion().compareTo(this.getMaxVersion());
        if (compare < 0) {
            return false;
        }
        return compare != 0 || !this.isMinVersionInclusive() || !this.isMaxVersionInclusive();
    }

    public List<VersionRange> getResidues(VersionRange range) {
        VersionRange upperResidue;
        LinkedList residues = Lists.newLinkedList();
        VersionRange lowerResidue = this.getLowerResidue(range);
        if (!lowerResidue.isEmpty()) {
            residues.add(lowerResidue);
        }
        if (!(upperResidue = this.getUpperResidue(range)).isEmpty()) {
            residues.add(upperResidue);
        }
        return residues;
    }

    private VersionRange getLowerResidue(VersionRange range) {
        return new VersionRange(this.getMinVersion(), this.isMinVersionInclusive(), range.getMinVersion(), !range.isMinVersionInclusive());
    }

    private VersionRange getUpperResidue(VersionRange range) {
        return new VersionRange(range.getMaxVersion(), !range.isMaxVersionInclusive(), this.getMaxVersion(), this.isMaxVersionInclusive());
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionRange) {
            VersionRange range = (VersionRange)obj;
            return this.minVersion.equals(range.minVersion) && this.maxVersion.equals(range.maxVersion) && this.minVersionInclusive == range.minVersionInclusive && this.maxVersionInclusive == range.maxVersionInclusive;
        }
        return false;
    }

    public int hashCode() {
        return this.minVersion.hashCode() ^ this.maxVersion.hashCode();
    }

    public static VersionRange create(String versionString) {
        VersionRange versionRange = new VersionRange();
        char firstChar = versionString.charAt(0);
        char lastChar = versionString.charAt(versionString.length() - 1);
        versionRange.minVersionInclusive = firstChar == '[';
        versionRange.maxVersionInclusive = lastChar == ']';
        String[] versions = versionString.substring(1, versionString.length() - 1).split(",");
        if (versions.length != 2) {
            throw new IllegalArgumentException(String.format("Given string '%s' is not a valid VersionRange.", versionString));
        }
        String minVersionString = versions[0].trim();
        String maxVersionString = versions[1].trim();
        versionRange.minVersion = VersionParserFactory.parse(minVersionString);
        versionRange.maxVersion = VersionParserFactory.parse(maxVersionString);
        return versionRange;
    }

    public static class VersionRangeBuilder {
        private Version minVersion = Version.ZERO;
        private boolean minVersionInclusive = true;
        private Version maxVersion = Version.LATEST;
        private boolean maxVersionInclusive = true;

        public VersionRangeBuilder minInclusive(Version version) {
            this.minVersionInclusive = true;
            this.minVersion = version;
            return this;
        }

        public VersionRangeBuilder minExclusive(Version version) {
            this.minVersionInclusive = false;
            this.minVersion = version;
            return this;
        }

        public VersionRangeBuilder maxInclusive(Version version) {
            this.maxVersionInclusive = true;
            this.maxVersion = version;
            return this;
        }

        public VersionRangeBuilder maxExclusive(Version version) {
            this.maxVersionInclusive = false;
            this.maxVersion = version;
            return this;
        }

        public VersionRange build() {
            return new VersionRange(this.minVersion, this.minVersionInclusive, this.maxVersion, this.maxVersionInclusive);
        }
    }
}

