/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.MatchLocations;
import org.eclipse.jdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchParticipantRecord;
import org.eclipse.jdt.internal.ui.search.SearchParticipantsExtensionPoint;
import org.eclipse.jdt.internal.ui.search.SearchResultUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class JavaSearchQuery
implements ISearchQuery {
    private static final String PERF_SEARCH_PARTICIPANT = "org.eclipse.jdt.ui/perf/search/participants";
    private ISearchResult fResult;
    private final QuerySpecification fPatternData;

    public JavaSearchQuery(QuerySpecification data) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.fPatternData = data;
    }

    public IStatus run(IProgressMonitor monitor) {
        JavaSearchResult textResult = (JavaSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine();
        try {
            SearchPattern pattern;
            String stringPattern;
            int totalTicks = 1000;
            IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(this.fPatternData.getScope());
            final SearchParticipantRecord[] participantDescriptors = SearchParticipantsExtensionPoint.getInstance().getSearchParticipants(projects);
            final int[] ticks = new int[participantDescriptors.length];
            int i = 0;
            while (i < participantDescriptors.length) {
                final int iPrime = i;
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ticks[iPrime] = 0;
                        String message = SearchMessages.JavaSearchQuery_error_participant_estimate;
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        ticks[iPrime] = participantDescriptors[iPrime].getParticipant().estimateTicks(JavaSearchQuery.this.fPatternData);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
                totalTicks += ticks[i];
                ++i;
            }
            if (this.fPatternData instanceof ElementQuerySpecification) {
                IJavaElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
                stringPattern = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                if (!element.exists()) {
                    return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_element_does_not_exist, stringPattern), null);
                }
                pattern = SearchPattern.createPattern((IJavaElement)element, (int)this.fPatternData.getLimitTo(), (int)24);
            } else {
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)this.fPatternData;
                stringPattern = patternSpec.getPattern();
                int matchMode = this.getMatchMode(stringPattern) | 0x10;
                if (patternSpec.isCaseSensitive()) {
                    matchMode |= 8;
                }
                pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode);
            }
            if (pattern == null) {
                return new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(SearchMessages.JavaSearchQuery_error_unsupported_pattern, stringPattern), null);
            }
            monitor.beginTask(Messages.format(SearchMessages.JavaSearchQuery_task_label, stringPattern), totalTicks);
            SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
            boolean ignorePotentials = NewSearchUI.arePotentialMatchesIgnored();
            NewSearchResultCollector collector = new NewSearchResultCollector(textResult, ignorePotentials);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.fPatternData.getScope(), (org.eclipse.jdt.core.search.SearchRequestor)collector, (IProgressMonitor)mainSearchPM);
            int i2 = 0;
            while (i2 < participantDescriptors.length) {
                final SearchRequestor requestor = new SearchRequestor(participantDescriptors[i2].getParticipant(), textResult);
                SubProgressMonitor participantPM = new SubProgressMonitor(monitor, ticks[i2]);
                final int iPrime = i2++;
                ISafeRunnable runnable = new ISafeRunnable((IProgressMonitor)participantPM){
                    private final /* synthetic */ IProgressMonitor val$participantPM;
                    {
                        this.val$participantPM = iProgressMonitor;
                    }

                    public void handleException(Throwable exception) {
                        participantDescriptors[iPrime].getDescriptor().disable();
                        String message = SearchMessages.JavaSearchQuery_error_participant_search;
                        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, exception));
                    }

                    public void run() throws Exception {
                        IQueryParticipant participant = participantDescriptors[iPrime].getParticipant();
                        PerformanceStats stats = PerformanceStats.getStats((String)JavaSearchQuery.PERF_SEARCH_PARTICIPANT, (Object)participant);
                        stats.startRun();
                        participant.search(requestor, JavaSearchQuery.this.fPatternData, this.val$participantPM);
                        stats.endRun();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        String message = Messages.format(SearchMessages.JavaSearchQuery_status_ok_message, String.valueOf(textResult.getMatchCount()));
        return new Status(0, JavaPlugin.getPluginId(), 0, message, null);
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern(pattern)) {
            return 128;
        }
        return 0;
    }

    public String getLabel() {
        return SearchMessages.JavaSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        int limitTo = this.getMaskedLimitTo();
        if (nMatches == 1) {
            Object[] args = new String[]{this.getSearchPatternDescription(), this.fPatternData.getScopeDescription()};
            switch (limitTo) {
                case 1: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularImplementorsPostfix, args);
                }
                case 0: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularDeclarationsPostfix, args);
                }
                case 2: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReferencesPostfix, args);
                }
                case 3: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularOccurrencesPostfix, args);
                }
                case 4: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularReadReferencesPostfix, args);
                }
                case 5: {
                    return Messages.format(SearchMessages.JavaSearchOperation_singularWriteReferencesPostfix, args);
                }
            }
            String matchLocations = MatchLocations.getMatchLocationDescription(limitTo, 3);
            return Messages.format(SearchMessages.JavaSearchQuery_singularReferencesWithMatchLocations, new Object[]{args[0], args[1], matchLocations});
        }
        Object[] args = new Object[]{this.getSearchPatternDescription(), new Integer(nMatches), this.fPatternData.getScopeDescription()};
        switch (limitTo) {
            case 1: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralImplementorsPostfix, args);
            }
            case 0: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralDeclarationsPostfix, args);
            }
            case 2: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReferencesPostfix, args);
            }
            case 3: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralOccurrencesPostfix, args);
            }
            case 4: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralReadReferencesPostfix, args);
            }
            case 5: {
                return Messages.format(SearchMessages.JavaSearchOperation_pluralWriteReferencesPostfix, args);
            }
        }
        String matchLocations = MatchLocations.getMatchLocationDescription(limitTo, 3);
        return Messages.format(SearchMessages.JavaSearchQuery_pluralReferencesWithMatchLocations, new Object[]{args[0], args[1], args[2], matchLocations});
    }

    private String getSearchPatternDescription() {
        if (this.fPatternData instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)this.fPatternData).getElement();
            return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x1000000000000L | 0x2000000000L);
        }
        return BasicElementLabels.getFilePattern(((PatternQuerySpecification)this.fPatternData).getPattern());
    }

    private int getMaskedLimitTo() {
        return this.fPatternData.getLimitTo() & 0xFFFFFFCF;
    }

    ImageDescriptor getImageDescriptor() {
        int limitTo = this.getMaskedLimitTo();
        if (limitTo == 1 || limitTo == 0) {
            return JavaPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            JavaSearchResult result = new JavaSearchResult(this);
            new SearchResultUpdater(result);
            this.fResult = result;
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    private static class SearchRequestor
    implements ISearchRequestor {
        private IQueryParticipant fParticipant;
        private JavaSearchResult fSearchResult;

        public void reportMatch(Match match) {
            IMatchPresentation participant = this.fParticipant.getUIParticipant();
            if (participant == null || match.getElement() instanceof IJavaElement || match.getElement() instanceof IResource) {
                this.fSearchResult.addMatch(match);
            } else {
                this.fSearchResult.addMatch(match, participant);
            }
        }

        protected SearchRequestor(IQueryParticipant participant, JavaSearchResult result) {
            this.fParticipant = participant;
            this.fSearchResult = result;
        }
    }
}

