/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private final long TITLE_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_TITLE_FLAGS = this.TITLE_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private final long TYPE_PARAMETER_TITLE_FLAGS = this.TITLE_FLAGS | 0x400000L;
    private static final long TOOLTIP_LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected IJavaElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    private IProgressMonitor fComputeProgressMonitor;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;
    private boolean fLinking = true;
    private IWorkbenchPart fLastSelectionProvider;
    protected LinkAction fToggleLinkAction;
    private static final String SYNCED_GIF = "synced.gif";
    private static final String SYNC_BROKEN_GIF = "sync_broken.gif";

    protected abstract void doSetInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected Object computeInput(IWorkbenchPart part, ISelection selection, IJavaElement element, IProgressMonitor monitor) {
        return this.computeInput(element);
    }

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        this.fToggleLinkAction = new LinkAction();
        this.fToggleLinkAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        this.fToggleLinkAction.updateLinkImage(false);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaElement getOrignalInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkAction));
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fToggleLinkAction);
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void inititalizeColors() {
        Color bgColor;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        registry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = registry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.fBackgroundColorRGB = bgColor.getRGB();
        } else {
            this.fBackgroundColor = bgColor = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(bgColor);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBackgroundColorKey().equals(event.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    protected void setLinkingEnabled(boolean enabled) {
        this.fLinking = enabled;
        if (this.fLinking && this.fLastSelectionProvider != null) {
            this.computeAndDoSetInput(this.fLastSelectionProvider, null, true);
        }
    }

    protected boolean isLinkingEnabled() {
        return this.fLinking;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        this.fLastSelectionProvider = part;
        if (this.fLinking) {
            this.computeAndSetInput(part);
        }
    }

    protected boolean isIgnoringNewInput(IJavaElement je, IWorkbenchPart part, ISelection selection) {
        return this.fCurrentViewInput != null && this.fCurrentViewInput.equals(je) && je != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        try {
            if (part instanceof JavaEditor && selection instanceof ITextSelection) {
                JavaEditor editor = (JavaEditor)part;
                IJavaElement[] elements = TextSelectionConverter.codeResolve(editor, (ITextSelection)selection);
                if (elements != null && elements.length > 0) {
                    return elements[0];
                }
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                ITextSelection methodSelection = this.guessMethodNamePosition(document, (ITextSelection)selection);
                if (methodSelection != null) return this.findSelectedJavaElement(part, (ISelection)methodSelection);
                return null;
            }
            if (!(selection instanceof IStructuredSelection)) return null;
            Object element = SelectionUtil.getSingleElement(selection);
            return this.findJavaElement(element);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private ITextSelection guessMethodNamePosition(IDocument document, ITextSelection selection) {
        int contextPosition = selection.getOffset();
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while (true) {
            int bracketBound;
            int bracket;
            int token;
            int paren;
            if ((paren = scanner.findOpeningPeer(pos, bound, '(', ')')) == -1) {
                try {
                    if (pos != contextPosition - 1 || document.getChar(pos) != ')') break;
                    paren = scanner.findOpeningPeer(pos - 1, bound, '(', ')');
                    if (paren == -1) {
                    }
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            if ((token = scanner.previousToken(paren - 1, bound)) == 2000) {
                return new TextSelection(document, paren, 0);
            }
            if (token == 14 && (bracket = scanner.findOpeningPeer(paren - 2, bracketBound = Math.max(-1, paren - 200), '<', '>')) != -1) {
                return new TextSelection(document, bracket, 0);
            }
            try {
                if (pos != contextPosition - 1 || document.getChar(pos) != ')') break;
                paren = pos;
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            pos = paren - 1;
        }
        return null;
    }

    private IJavaElement findJavaElement(Object element) {
        if (element == null) {
            return null;
        }
        IJavaElement je = null;
        if (element instanceof IAdaptable) {
            je = (IJavaElement)((IAdaptable)element).getAdapter(IJavaElement.class);
        }
        if (je != null && je.exists()) {
            return je;
        }
        return null;
    }

    protected IType getTypeForCU(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();

    private void computeAndSetInput(IWorkbenchPart part) {
        this.computeAndDoSetInput(part, null, false);
    }

    public final void setInput(IJavaElement element) {
        this.computeAndDoSetInput(null, element, false);
    }

    private void computeAndDoSetInput(final IWorkbenchPart part, final IJavaElement element, boolean resetIfInvalid) {
        ISelection selection;
        Assert.isLegal((part != null || element != null ? 1 : 0) != 0);
        final int currentCount = ++this.fComputeCount;
        if (element != null) {
            selection = null;
        } else {
            ISelectionProvider provider = part.getSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            selection = provider.getSelection();
            if (selection == null) {
                return;
            }
        }
        if (this.fComputeProgressMonitor != null) {
            this.fComputeProgressMonitor.setCanceled(true);
        }
        NullProgressMonitor computeProgressMonitor = new NullProgressMonitor();
        this.fComputeProgressMonitor = computeProgressMonitor;
        Thread thread = new Thread("Info view input computer", (IProgressMonitor)computeProgressMonitor, resetIfInvalid){
            private final /* synthetic */ IProgressMonitor val$computeProgressMonitor;
            private final /* synthetic */ boolean val$resetIfInvalid;
            {
                this.val$computeProgressMonitor = iProgressMonitor;
                this.val$resetIfInvalid = bl;
                super($anonymous0);
            }

            public void run() {
                Object oldInput;
                IJavaElement oldElement;
                IJavaElement je;
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                if (element != null) {
                    je = element;
                } else {
                    je = AbstractInfoView.this.findSelectedJavaElement(part, selection);
                    if (AbstractInfoView.this.isIgnoringNewInput(je, part, selection)) {
                        this.updateLinkImage(false);
                        return;
                    }
                }
                final Object input = AbstractInfoView.this.computeInput(part, selection, je, this.val$computeProgressMonitor);
                if (input == null && !this.val$resetIfInvalid && AbstractInfoView.this.fCurrentViewInput != null && (oldElement = AbstractInfoView.this.fCurrentViewInput) != null && oldElement.exists() && (oldInput = AbstractInfoView.this.computeInput(null, null, oldElement, this.val$computeProgressMonitor)) != null) {
                    this.updateLinkImage(true);
                    return;
                }
                final String description = input != null ? AbstractInfoView.this.computeDescription(part, selection, je, this.val$computeProgressMonitor) : "";
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractInfoView.this.fComputeCount != currentCount || AbstractInfoView.this.getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        (this).AbstractInfoView.this.fCurrentViewInput = je;
                        AbstractInfoView.this.doSetInput(input, description);
                        (this).AbstractInfoView.this.fToggleLinkAction.updateLinkImage(false);
                        AbstractInfoView.this.fComputeProgressMonitor = null;
                    }
                });
            }

            private void updateLinkImage(final boolean isBroken) {
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        (this).AbstractInfoView.this.fToggleLinkAction.updateLinkImage(isBroken);
                    }
                });
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    protected String computeDescription(IWorkbenchPart part, ISelection selection, IJavaElement inputElement, IProgressMonitor localASTMonitor) {
        long flags = inputElement instanceof ILocalVariable ? this.LOCAL_VARIABLE_TITLE_FLAGS : (inputElement instanceof ITypeParameter ? this.TYPE_PARAMETER_TITLE_FLAGS : this.TITLE_FLAGS);
        return JavaElementLabels.getElementLabel(inputElement, flags);
    }

    private void doSetInput(Object input, String description) {
        this.doSetInput(input);
        boolean hasValidInput = input != null;
        this.fGotoInputAction.setEnabled(hasValidInput);
        IJavaElement inputElement = this.getOrignalInput();
        String toolTip = hasValidInput && inputElement != null ? JavaElementLabels.getElementLabel(inputElement, TOOLTIP_LABEL_FLAGS) : "";
        this.setContentDescription(description);
        this.setTitleToolTip(toolTip);
    }

    private class LinkAction
    extends Action {
        private String fIconName;

        public LinkAction() {
            super(InfoViewMessages.LinkAction_label, 2);
            this.setToolTipText(InfoViewMessages.LinkAction_tooltip);
            this.setChecked(AbstractInfoView.this.fLinking);
        }

        public void run() {
            AbstractInfoView.this.setLinkingEnabled(!AbstractInfoView.this.fLinking);
            this.updateLinkImage(false);
        }

        public void updateLinkImage(boolean isBroken) {
            String iconName;
            String string = iconName = isBroken ? AbstractInfoView.SYNC_BROKEN_GIF : AbstractInfoView.SYNCED_GIF;
            if (!iconName.equals(this.fIconName)) {
                JavaPluginImages.setLocalImageDescriptors((IAction)AbstractInfoView.this.fToggleLinkAction, iconName);
                this.setToolTipText(isBroken ? InfoViewMessages.LinkAction_last_input_tooltip : InfoViewMessages.LinkAction_tooltip);
                this.fIconName = iconName;
            }
        }
    }
}

