/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.chain;

import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.internal.completion.rcp.chain.Chain;
import org.eclipse.recommenders.internal.completion.rcp.chain.ChainElement;
import org.eclipse.recommenders.internal.completion.rcp.chain.TypeBindingAnalyzer;
import org.eclipse.recommenders.utils.Checks;

public class ChainFinder {
    private final List<Optional<TypeBinding>> expectedTypes;
    private final Set<String> excludedTypes;
    private final InvocationSite invocationSite;
    private final Scope scope;
    private final List<Chain> chains = Lists.newLinkedList();
    private final Map<Binding, ChainElement> edgeCache = Maps.newHashMap();
    private final Map<TypeBinding, List<Binding>> fieldsAndMethodsCache = Maps.newHashMap();
    private final Table<ChainElement, TypeBinding, Boolean> assignableCache = HashBasedTable.create();

    ChainFinder(List<Optional<TypeBinding>> expectedTypes, Set<String> excludedTypes, InvocationSite invocationSite, Scope scope) {
        this.expectedTypes = expectedTypes;
        this.excludedTypes = excludedTypes;
        this.invocationSite = invocationSite;
        this.scope = scope;
    }

    void startChainSearch(List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        for (Optional<TypeBinding> expected : this.expectedTypes) {
            if (!expected.isPresent() || this.isFromExcludedType((Binding)expected.get())) continue;
            TypeBinding expectedType = (TypeBinding)expected.get();
            int expectedDimension = 0;
            if (expectedType instanceof ArrayBinding) {
                expectedDimension = ((ArrayBinding)expectedType).dimensions();
                expectedType = TypeBindingAnalyzer.removeArrayWrapper(expectedType);
            }
            this.searchChainsForExpectedType(expectedType, expectedDimension, entrypoints, maxChains, minDepth, maxDepth);
        }
    }

    private void searchChainsForExpectedType(TypeBinding expectedType, int expectedDimensions, List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        LinkedList<LinkedList<ChainElement>> incompleteChains = ChainFinder.prepareQueue(entrypoints);
        while (!incompleteChains.isEmpty()) {
            LinkedList<ChainElement> chain = incompleteChains.poll();
            ChainElement edge = chain.getLast();
            if (this.isValidEndOfChain(edge, expectedType, expectedDimensions)) {
                if (!ChainFinder.isValidChain(chain, minDepth)) continue;
                this.chains.add(new Chain(chain, expectedDimensions));
                if (this.chains.size() != maxChains) continue;
                break;
            }
            if (chain.size() >= maxDepth || incompleteChains.size() > 50000) continue;
            this.searchDeeper(chain, incompleteChains, edge.getReturnType());
        }
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    private static LinkedList<LinkedList<ChainElement>> prepareQueue(List<ChainElement> entrypoints) {
        LinkedList incompleteChains = Lists.newLinkedList();
        for (ChainElement entrypoint : entrypoints) {
            LinkedList chain = Lists.newLinkedList();
            chain.add(entrypoint);
            incompleteChains.add(chain);
        }
        return incompleteChains;
    }

    private boolean isFromExcludedType(Binding binding) {
        String key = StringUtils.substringBefore((String)String.valueOf(binding.computeUniqueKey()), (String)";");
        return this.excludedTypes.contains(key);
    }

    private boolean isValidEndOfChain(ChainElement edge, TypeBinding expectedType, int expectedDimension) {
        Boolean isAssignable = (Boolean)this.assignableCache.get((Object)edge, (Object)expectedType);
        if (isAssignable == null) {
            isAssignable = TypeBindingAnalyzer.isAssignable(edge, expectedType, expectedDimension);
            this.assignableCache.put((Object)edge, (Object)expectedType, (Object)isAssignable);
        }
        return isAssignable;
    }

    private static boolean isValidChain(LinkedList<ChainElement> chain, int minDepth) {
        return chain.size() >= minDepth;
    }

    private void searchDeeper(LinkedList<ChainElement> chain, List<LinkedList<ChainElement>> incompleteChains, TypeBinding currentlyVisitedType) {
        for (Binding element : this.findAllFieldsAndMethods(currentlyVisitedType)) {
            ChainElement newEdge = this.createEdge(element);
            if (chain.contains(newEdge)) continue;
            incompleteChains.add(ChainFinder.cloneChainAndAppendEdge(chain, newEdge));
        }
    }

    private List<Binding> findAllFieldsAndMethods(TypeBinding chainElementType) {
        LinkedList cached = this.fieldsAndMethodsCache.get(chainElementType);
        if (cached == null) {
            cached = Lists.newLinkedList();
            for (Binding binding : TypeBindingAnalyzer.findVisibleInstanceFieldsAndRelevantInstanceMethods(chainElementType, this.invocationSite, this.scope)) {
                if (this.isFromExcludedType(binding)) continue;
                cached.add(binding);
            }
            this.fieldsAndMethodsCache.put(chainElementType, cached);
        }
        return cached;
    }

    private ChainElement createEdge(Binding member) {
        ChainElement cached = this.edgeCache.get(member);
        if (cached == null) {
            cached = new ChainElement(member, false);
            this.edgeCache.put(member, cached);
        }
        return cached;
    }

    private static LinkedList<ChainElement> cloneChainAndAppendEdge(LinkedList<ChainElement> chain, ChainElement newEdge) {
        LinkedList chainCopy = (LinkedList)Checks.cast((Object)chain.clone());
        chainCopy.add(newEdge);
        return chainCopy;
    }
}

