/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TabContainerConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TabContainerUiContentProvider;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.UIContentContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableColumnContainerUiContentProvider
extends TabContainerUiContentProvider {
    private final JTableBindingInfo m_binding;
    private final List<BindingInfo> m_bindings;
    private final DatabindingsProvider m_provider;

    public JTableColumnContainerUiContentProvider(TabContainerConfiguration configuration, JTableBindingInfo binding, List<BindingInfo> bindings, DatabindingsProvider provider) {
        super(configuration);
        this.m_binding = binding;
        this.m_bindings = bindings;
        this.m_provider = provider;
    }

    protected IUiContentProvider createNewPageContentProvider() throws Exception {
        return new UIContentContainer<ColumnBindingInfo>(this.m_binding.createNewColumnBinding(-1), this.m_bindings, Messages.JTableColumnContainerUiContentProvider_column, this.m_provider);
    }

    protected void configute(CTabItem tabItem, int index, IUiContentProvider provider) {
        tabItem.setText(MessageFormat.format(Messages.JTableColumnContainerUiContentProvider_columnIndex, index));
    }

    public void updateFromObject() throws Exception {
        List providers = Lists.newArrayList();
        for (ColumnBindingInfo binding : this.m_binding.getColumns()) {
            providers.add(new UIContentContainer<ColumnBindingInfo>(binding, this.m_bindings, Messages.JTableColumnContainerUiContentProvider_column, this.m_provider));
        }
        this.updateFromObject(providers);
    }

    protected void saveToObject(List<IUiContentProvider> providers) throws Exception {
        List columns = Lists.newArrayList();
        for (IUiContentProvider provider : providers) {
            UIContentContainer container = (UIContentContainer)provider;
            columns.add((ColumnBindingInfo)container.getBinding());
        }
        this.m_binding.setColumns(columns, this.m_bindings);
    }
}

