/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizeWizardPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSynchronizeWizard
extends Wizard {
    private GitSynchronizeWizardPage page;

    public GitSynchronizeWizard() {
        this.setWindowTitle(UIText.GitSynchronizeWizard_synchronize);
    }

    public void addPages() {
        this.page = new GitSynchronizeWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        GitSynchronizeDataSet gsdSet = new GitSynchronizeDataSet(this.page.forceFetch());
        Map<Repository, String> branches = this.page.getSelectedBranches();
        boolean shouldIncludeLocal = this.page.shouldIncludeLocal();
        for (Map.Entry<Repository, String> branchesEntry : branches.entrySet()) {
            try {
                Repository repo = branchesEntry.getKey();
                GitSynchronizeData data = new GitSynchronizeData(repo, "HEAD", branchesEntry.getValue(), shouldIncludeLocal);
                Set<IContainer> containers = this.getSelectedContainers(repo);
                if (containers != null && containers.size() > 0) {
                    data.setIncludedPaths(containers);
                }
                gsdSet.add(data);
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        Set<IProject> selectedProjects = this.page.getSelectedProjects();
        GitModelSynchronize.launch(gsdSet, selectedProjects.toArray(new IResource[selectedProjects.size()]));
        return true;
    }

    private Set<IContainer> getSelectedContainers(Repository repo) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            HashSet<IContainer> result = new HashSet<IContainer>();
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 0) {
                return null;
            }
            File workTree = repo.getWorkTree();
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository selRepo;
                int type;
                IResource res;
                Object o = objectArray[n2];
                if (o instanceof IAdaptable && (res = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null && (type = res.getType()) == 2 && workTree.equals((selRepo = RepositoryMapping.getMapping((IResource)res).getRepository()).getWorkTree())) {
                    result.add((IContainer)res);
                }
                ++n2;
            }
            return result;
        }
        return null;
    }
}

