/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.pull.MultiPullResultDialog;
import org.eclipse.egit.ui.internal.pull.PullResultDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullOperationUI
extends JobChangeAdapter {
    private static final IStatus NOT_TRIED_STATUS = new Status(4, Activator.getPluginId(), UIText.PullOperationUI_NotTriedMessage);
    private final Repository[] repositories;
    private final Map<Repository, Object> results = new LinkedHashMap<Repository, Object>();
    private final PullOperation pullOperation;

    public PullOperationUI(Set<Repository> repositories) {
        this.repositories = repositories.toArray(new Repository[repositories.size()]);
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        this.pullOperation = new PullOperation(repositories, timeout);
        for (Repository repository : repositories) {
            this.results.put(repository, NOT_TRIED_STATUS);
        }
    }

    public void start() {
        String jobName;
        if (this.repositories.length == 1) {
            String shortBranchName;
            String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repositories[0]);
            try {
                shortBranchName = this.repositories[0].getBranch();
            }
            catch (IOException iOException) {
                shortBranchName = "";
            }
            jobName = NLS.bind((String)UIText.PullOperationUI_PullingTaskName, (Object)shortBranchName, (Object)repoName);
        } else {
            jobName = UIText.PullOperationUI_PullingMultipleTaskName;
        }
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                PullOperationUI.this.execute(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PULL.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)this);
        job.schedule();
    }

    public void execute(IProgressMonitor monitor) {
        try {
            this.pullOperation.execute(monitor);
            this.results.putAll(this.pullOperation.getResults());
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                this.results.putAll(this.pullOperation.getResults());
            }
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    public void done(IJobChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PullOperationUI.this.showResults(shell);
            }
        });
    }

    private void showResults(Shell shell) {
        if (this.results.isEmpty()) {
            return;
        }
        if (this.results.size() == 1) {
            Map.Entry<Repository, Object> entry = this.results.entrySet().iterator().next();
            if (entry.getValue() instanceof PullResult) {
                new PullResultDialog(shell, entry.getKey(), (PullResult)entry.getValue()).open();
            } else {
                IStatus status = (IStatus)entry.getValue();
                if (status == NOT_TRIED_STATUS) {
                    MessageDialog.openInformation((Shell)shell, (String)UIText.PullOperationUI_PullCanceledWindowTitle, (String)UIText.PullOperationUI_PullOperationCanceledMessage);
                } else if (status.getException() instanceof TransportException) {
                    ErrorDialog.openError((Shell)shell, (String)UIText.PullOperationUI_PullFailed, (String)UIText.PullOperationUI_ConnectionProblem, (IStatus)status);
                } else {
                    Activator.handleError(status.getMessage(), status.getException(), true);
                }
            }
        } else {
            new MultiPullResultDialog(shell, this.results).open();
        }
    }
}

