/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.lang.reflect.Method;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;

public class ResourcePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean value = this.internalTest(receiver, property);
        boolean trace = GitTraceLocation.PROPERTIESTESTER.isActive();
        if (trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.PROPERTIESTESTER.getLocation(), "prop " + property + " of " + receiver + " = " + value + ", expected = " + expectedValue);
        }
        return value;
    }

    private boolean internalTest(Object receiver, String property) {
        if (!(receiver instanceof IResource)) {
            return false;
        }
        IResource res = (IResource)receiver;
        if ("isContainer".equals(property)) {
            int type = res.getType();
            return type == 2 || type == 4;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)res.getProject());
        if (mapping != null) {
            Repository repository = mapping.getRepository();
            return ResourcePropertyTester.testRepositoryState(repository, property);
        }
        return false;
    }

    public static boolean testRepositoryState(Repository repository, String property) {
        if ("isShared".equals(property)) {
            return repository != null;
        }
        if (repository != null) {
            RepositoryState state = repository.getRepositoryState();
            if (property.length() > 3 && property.startsWith("is")) {
                String lookFor = String.valueOf(property.substring(2, 3)) + property.substring(3).replaceAll("([A-Z])", "_$1").toUpperCase();
                if (state.toString().equals(lookFor)) {
                    return true;
                }
            }
            try {
                Method method = RepositoryState.class.getMethod(property, new Class[0]);
                if (method.getReturnType() == Boolean.TYPE) {
                    Boolean ret = (Boolean)method.invoke((Object)state, new Object[0]);
                    return ret;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

