/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.preferences;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.recommenders.completion.rcp.calls.l10n.Messages;
import org.eclipse.recommenders.rcp.ClasspathEntryInfo;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.swt.graphics.Image;

public class VersionLabelProvider
extends ColumnLabelProvider {
    @VisibleForTesting
    public static final String DEPENDENCY_DETAILS_UNKNOWN = Messages.PREFPAGE_DEPENDENCY_DETAILS_UNKNOWN;
    @VisibleForTesting
    public static final String DEPENDENCY_DETAILS_KNOWN = Messages.PREFPAGE_DEPENDENCY_DETAILS_KNOWN;
    private final Image versionUnknownImage;
    private final Image versionImage;

    public VersionLabelProvider(Image versionUnknownImage, Image versionImage) {
        this.versionUnknownImage = versionUnknownImage;
        this.versionImage = versionImage;
    }

    public Image getImage(Object element) {
        return this.hasDependencyInformation(element) ? this.versionImage : this.versionUnknownImage;
    }

    public String getToolTipText(Object element) {
        if (this.hasDependencyInformation(element)) {
            return DEPENDENCY_DETAILS_KNOWN;
        }
        return DEPENDENCY_DETAILS_UNKNOWN;
    }

    private boolean hasDependencyInformation(Object element) {
        Tuple e = (Tuple)Checks.cast((Object)element);
        ClasspathEntryInfo cpei = (ClasspathEntryInfo)e.getFirst();
        return !StringUtils.isEmpty((CharSequence)cpei.getSymbolicName()) && !cpei.getVersion().isUnknown();
    }
}

