/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.preferences;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.recommenders.completion.rcp.calls.l10n.Messages;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.swt.graphics.Image;
import org.sonatype.aether.artifact.Artifact;

public class ModelLabelProvider
extends ColumnLabelProvider {
    @VisibleForTesting
    public static final String MODEL_NOT_AVAILABLE = Messages.PREFPAGE_MODLE_NOT_AVAILABLE;
    @VisibleForTesting
    public static final String MODEL_AVAILABLE = Messages.PREFPAGE_MODEL_AVAILABLE;
    private final Image modelImage;
    private final Image modelUnknownImage;
    private final IModelRepository repository;

    public ModelLabelProvider(IModelRepository repository, Image modelImage, Image modelUnknownImage) {
        this.repository = repository;
        this.modelImage = modelImage;
        this.modelUnknownImage = modelUnknownImage;
    }

    public Image getImage(Object element) {
        return this.hasModel(element) ? this.modelImage : this.modelUnknownImage;
    }

    public String getToolTipText(Object element) {
        if (this.hasModel(element)) {
            return MODEL_AVAILABLE;
        }
        return MODEL_NOT_AVAILABLE;
    }

    private boolean hasModel(Object element) {
        Tuple e = (Tuple)Checks.cast((Object)element);
        Optional opt = ((ModelArchiveMetadata)e.getSecond()).getArtifact();
        if (!opt.isPresent()) {
            return false;
        }
        File location = this.repository.location((Artifact)opt.get());
        return location.exists();
    }
}

