/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.sampling;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.sampling.ISampler;
import org.eclipse.recommenders.jayes.util.BayesUtils;

public class BasicSampler
implements ISampler {
    private List<BayesNode> topologicallySortedNodes;
    private Map<BayesNode, String> evidence = Collections.emptyMap();
    private Random random = new Random();

    @Override
    public Map<BayesNode, String> sample() {
        HashMap<BayesNode, String> result = new HashMap<BayesNode, String>();
        result.putAll(this.evidence);
        for (BayesNode n : this.topologicallySortedNodes) {
            if (this.evidence.containsKey(n)) continue;
            int newEvidence = this.sampleOutcome(n, result);
            result.put(n, n.getOutcomeName(newEvidence));
        }
        return result;
    }

    private int sampleOutcome(BayesNode node, Map<BayesNode, String> currentSample) {
        double[] probs = node.marginalize(currentSample);
        double currentProb = 0.0;
        int newEvidence = 0;
        double rand = this.random.nextDouble();
        double[] dArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            double prob = dArray[n2];
            if (rand < (currentProb += prob)) break;
            ++newEvidence;
            ++n2;
        }
        return Math.min(newEvidence, node.getOutcomeCount() - 1);
    }

    @Override
    public void setBN(BayesNet net) {
        this.topologicallySortedNodes = BayesUtils.topsort(net.getNodes());
    }

    @Override
    public void setEvidence(Map<BayesNode, String> evidence) {
        this.evidence = evidence;
    }

    public void seed(long seed) {
        this.random.setSeed(seed);
    }
}

