/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import java.beans.PropertyDescriptor;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.EnumPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditorProvider;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionPropertiesHelper {
    private static final String POINT_PROPERTY_EDITORS = "org.eclipse.wb.core.propertyEditors";
    private static final String POINT_PROPERTY_CONVERTERS = "org.eclipse.wb.core.propertyConverters";

    private DescriptionPropertiesHelper() {
    }

    public static PropertyEditor getEditorForType(Class<?> type) throws Exception {
        if (type.isEnum()) {
            return EnumPropertyEditor.INSTANCE;
        }
        for (PropertyEditorProvider provider : DescriptionPropertiesHelper.getPropertyEditorProviders()) {
            PropertyEditor editor = provider.getEditorForType(type);
            if (editor == null) continue;
            return editor;
        }
        String typeName = ReflectionUtils.getFullyQualifiedName(type, (boolean)false);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_EDITORS, (String)"editor");
        for (IConfigurationElement element : elements) {
            if (!typeName.equals(element.getAttribute("type"))) continue;
            return (PropertyEditor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        return null;
    }

    public static PropertyEditor getEditorForPropertyDescriptor(PropertyDescriptor descriptor) throws Exception {
        List<PropertyEditorProvider> providers = DescriptionPropertiesHelper.getPropertyEditorProviders();
        for (PropertyEditorProvider provider : providers) {
            PropertyEditor editor = provider.getEditorForPropertyDescriptor(descriptor);
            if (editor == null) continue;
            return editor;
        }
        return null;
    }

    public static PropertyEditor getEditorForEditorType(Class<?> editorType) throws Exception {
        List<PropertyEditorProvider> providers = DescriptionPropertiesHelper.getPropertyEditorProviders();
        for (PropertyEditorProvider provider : providers) {
            PropertyEditor editor = provider.getEditorForEditorType(editorType);
            if (editor == null) continue;
            return editor;
        }
        return null;
    }

    private static List<PropertyEditorProvider> getPropertyEditorProviders() {
        return ExternalFactoriesHelper.getElementsInstances(PropertyEditorProvider.class, (String)POINT_PROPERTY_EDITORS, (String)"provider");
    }

    public static PropertyEditor getConfigurableEditor(String id) throws Exception {
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_EDITORS, (String)"configurableEditor");
        for (IConfigurationElement element : elements) {
            if (!id.equals(element.getAttribute("id"))) continue;
            return (PropertyEditor)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        throw new IllegalArgumentException("Can not find configurable editor with id '" + id + "'.");
    }

    public static ExpressionConverter getConverterForType(Class<?> type) throws Exception {
        String typeName = ReflectionUtils.getFullyQualifiedName(type, (boolean)false);
        List elements = ExternalFactoriesHelper.getElements((String)POINT_PROPERTY_CONVERTERS, (String)"converter");
        for (IConfigurationElement element : elements) {
            if (!typeName.equals(element.getAttribute("type"))) continue;
            return (ExpressionConverter)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
        }
        return null;
    }
}

