/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class BooleanEvaluator
implements IExpressionEvaluator {
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("boolean".equals(typeQualifiedName)) {
            if (expression instanceof BooleanLiteral) {
                BooleanLiteral numberLiteral = (BooleanLiteral)expression;
                return numberLiteral.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (expression instanceof PrefixExpression) {
                PrefixExpression prefixExpression = (PrefixExpression)expression;
                Assert.isTrue((prefixExpression.getOperator() == PrefixExpression.Operator.NOT ? 1 : 0) != 0);
                Expression operand = prefixExpression.getOperand();
                boolean operandValue = BooleanEvaluator.getBooleanValue(context, operand);
                return !operandValue;
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                InfixExpression.Operator operator = infixExpression.getOperator();
                Expression leftOperand = infixExpression.getLeftOperand();
                Expression rightOperand = infixExpression.getRightOperand();
                if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
                    Object leftObject = AstEvaluationEngine.evaluate(context, leftOperand);
                    Object rightObject = AstEvaluationEngine.evaluate(context, rightOperand);
                    if (operator == InfixExpression.Operator.EQUALS) {
                        return ObjectUtils.equals((Object)leftObject, (Object)rightObject);
                    }
                    if (operator == InfixExpression.Operator.NOT_EQUALS) {
                        return !ObjectUtils.equals((Object)leftObject, (Object)rightObject);
                    }
                }
                List<Expression> extendedOperands = DomGenerics.extendedOperands(infixExpression);
                boolean[] operands = new boolean[2 + extendedOperands.size()];
                operands[0] = BooleanEvaluator.getBooleanValue(context, leftOperand);
                operands[1] = BooleanEvaluator.getBooleanValue(context, rightOperand);
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = BooleanEvaluator.getBooleanValue(context, operandExpression);
                    ++i;
                }
                boolean value = operands[0];
                boolean[] blArray = operands;
                int n = operands.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean operand = blArray[n2];
                    if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                        value &= operand;
                    } else if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                        value |= operand;
                    }
                    ++n2;
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static boolean getBooleanValue(EvaluationContext context, Expression expression) throws Exception {
        Boolean value = (Boolean)AstEvaluationEngine.evaluate(context, expression);
        return value;
    }
}

