/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitedLinesHighlighter
implements IPainter,
LineBackgroundListener {
    private boolean m_shouldHighlight;
    private Color m_color;
    private final List<Position> m_linePositions = Lists.newArrayList();
    private final ISourceViewer m_sourceViewer;
    private final IDocument m_document;
    private final StyledText m_textWidget;
    private final ITextViewerExtension2 m_extension2;
    private final ITextViewerExtension5 m_extension5;
    private IPaintPositionManager m_positionManager;
    IPropertyChangeListener m_preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            VisitedLinesHighlighter.this.trackPreferences_getCurrentValues();
            VisitedLinesHighlighter.this.m_textWidget.redraw();
        }
    };

    public VisitedLinesHighlighter(ISourceViewer sourceViewer) {
        this.m_sourceViewer = sourceViewer;
        this.m_document = this.m_sourceViewer.getDocument();
        this.m_textWidget = sourceViewer.getTextWidget();
        this.m_extension2 = (ITextViewerExtension2)sourceViewer;
        this.m_extension5 = (ITextViewerExtension5)this.m_sourceViewer;
        this.m_extension2.addPainter((IPainter)this);
        this.m_textWidget.addLineBackgroundListener((LineBackgroundListener)this);
        this.trackPreferences();
    }

    private void trackPreferences() {
        this.trackPreferences_getCurrentValues();
        DesignerPlugin.getPreferences().addPropertyChangeListener(this.m_preferenceListener);
    }

    private void trackPreferences_getCurrentValues() {
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        this.m_shouldHighlight = preferences.getBoolean("editor.highlightVisitedLines");
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preferences, (String)"editor.highlightVisitedLines.color");
        this.m_color = SwtResourceManager.getColor((RGB)rgb);
    }

    public void setVisitedNodes(Collection<ASTNode> nodes) throws Exception {
        for (Position position : this.m_linePositions) {
            this.m_positionManager.unmanagePosition(position);
        }
        Set lines = Sets.newHashSet();
        for (ASTNode node : nodes) {
            int line = this.m_document.getLineOfOffset(node.getStartPosition());
            lines.add(line);
        }
        this.m_linePositions.clear();
        for (Integer line : lines) {
            int lineOffset = this.m_document.getLineOffset(line.intValue());
            Position position = new Position(lineOffset);
            this.m_linePositions.add(position);
            this.m_positionManager.managePosition(position);
        }
        ExecutionUtils.runAsync((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                VisitedLinesHighlighter.this.m_textWidget.redraw();
            }
        });
    }

    public void setPositionManager(IPaintPositionManager manager) {
        this.m_positionManager = manager;
    }

    public void paint(int reason) {
    }

    public void deactivate(boolean redraw) {
    }

    public void dispose() {
        DesignerPlugin.getPreferences().removePropertyChangeListener(this.m_preferenceListener);
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        Color defaultBackground;
        if (!this.m_shouldHighlight) {
            return;
        }
        int lineOffset = event.lineOffset;
        lineOffset = this.m_extension5.widgetOffset2ModelOffset(lineOffset);
        if (event.lineBackground != null && !event.lineBackground.equals((Object)(defaultBackground = this.m_textWidget.getBackground()))) {
            return;
        }
        for (Position position : this.m_linePositions) {
            if (position.isDeleted() || position.getOffset() != lineOffset) continue;
            event.lineBackground = this.m_color;
            break;
        }
    }
}

