/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverConfigurationIO {
    private static final Logger log = LoggerFactory.getLogger(ResolverConfigurationIO.class);
    private static final String P_VERSION = "version";
    private static final String P_RESOLVE_WORKSPACE_PROJECTS = "resolveWorkspaceProjects";
    private static final String P_SELECTED_PROFILES = "activeProfiles";
    private static final String P_LIFECYCLE_MAPPING_ID = "lifecycleMappingId";
    private static final String VERSION = "1";

    public static boolean saveResolverConfiguration(IProject project, ResolverConfiguration configuration) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.m2e.core");
        if (projectNode != null) {
            projectNode.put(P_VERSION, VERSION);
            projectNode.putBoolean(P_RESOLVE_WORKSPACE_PROJECTS, configuration.shouldResolveWorkspaceProjects());
            projectNode.put(P_SELECTED_PROFILES, configuration.getSelectedProfiles());
            if (configuration.getLifecycleMappingId() != null) {
                projectNode.put(P_LIFECYCLE_MAPPING_ID, configuration.getLifecycleMappingId());
            } else {
                projectNode.remove(P_LIFECYCLE_MAPPING_ID);
            }
            try {
                projectNode.flush();
                return true;
            }
            catch (BackingStoreException ex) {
                log.error("Failed to save resolver configuration", (Throwable)ex);
            }
        }
        return false;
    }

    public static ResolverConfiguration readResolverConfiguration(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.m2e.core");
        if (projectNode == null) {
            return new ResolverConfiguration();
        }
        String version = projectNode.get(P_VERSION, null);
        if (version == null) {
            return new ResolverConfiguration();
        }
        ResolverConfiguration configuration = new ResolverConfiguration();
        configuration.setResolveWorkspaceProjects(projectNode.getBoolean(P_RESOLVE_WORKSPACE_PROJECTS, false));
        configuration.setSelectedProfiles(projectNode.get(P_SELECTED_PROFILES, ""));
        configuration.setLifecycleMappingId(projectNode.get(P_LIFECYCLE_MAPPING_ID, null));
        return configuration;
    }
}

