/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.wiring;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProviderDescription;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocPreferences;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ExtdocPlugin;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ManualModelStoreWiring;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExtdocModule
extends AbstractModule {
    protected void configure() {
        this.bind(ExtdocPreferences.class).in(Scopes.SINGLETON);
        this.bind(ManualModelStoreWiring.ClassOverridesPatternsModelStore.class).in(Scopes.SINGLETON);
        this.bind(ManualModelStoreWiring.ClassOverridesModelStore.class).in(Scopes.SINGLETON);
        this.bind(ManualModelStoreWiring.ClassSelfcallsModelStore.class).in(Scopes.SINGLETON);
        this.bind(ManualModelStoreWiring.MethodSelfcallsModelStore.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Extdoc
    IPreferenceStore providePreferenceStore() {
        return ExtdocPlugin.getDefault().getPreferenceStore();
    }

    @Provides
    @Singleton
    List<ExtdocProvider> provideProviders() {
        List<ExtdocProvider> providers = ExtdocModule.instantiateProvidersFromRegistry();
        return providers;
    }

    static List<ExtdocProvider> instantiateProvidersFromRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.extdoc.rcp.provider");
        LinkedList providers = Lists.newLinkedList();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Optional<ExtdocProvider> opt = ExtdocModule.createProvider(element);
            if (opt.isPresent()) {
                providers.add((ExtdocProvider)opt.get());
            }
            ++n2;
        }
        Collections.sort(providers, new Comparator<ExtdocProvider>(){

            @Override
            public int compare(ExtdocProvider o1, ExtdocProvider o2) {
                String n1 = o1.getDescription().getName();
                String n2 = o2.getDescription().getName();
                if (n1.equals("Javadoc")) {
                    return -1;
                }
                if (n2.equals("Javadoc")) {
                    return 1;
                }
                return n1.compareTo(n2);
            }
        });
        return providers;
    }

    static Optional<ExtdocProvider> createProvider(IConfigurationElement element) {
        String pluginId = element.getContributor().getName();
        try {
            String imagePath = element.getAttribute("image");
            String name = element.getAttribute("name");
            Image image = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)imagePath).createImage();
            ExtdocProvider provider = (ExtdocProvider)element.createExecutableExtension("class");
            ExtdocProviderDescription description = new ExtdocProviderDescription(name, image);
            provider.setDescription(description);
            return Optional.of((Object)provider);
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"failed to instantiate provider %s:%s", (Object[])new Object[]{pluginId, element.getAttribute("class")});
            return Optional.absent();
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Extdoc {
    }
}

