/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.recommenders.extdoc.rcp.l10n.Messages;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocPreferences;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocProviderTransfer;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.SubscriptionManager;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.rcp.PartListener2Adapter;
import org.eclipse.recommenders.utils.rcp.RCPUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class ExtdocView
extends ViewPart {
    public static final String ID = "org.eclipse.recommenders.extdoc.rcp.ExtdocView";
    private final EventBus workspaceBus;
    private final SubscriptionManager subscriptionManager;
    private final List<ExtdocProvider> providers;
    private final ExtdocPreferences preferences;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private static final int MOVE_AFTER = 1;
    private static final int MOVE_BEFORE = 0;
    private final JavaElementLabelProvider labelProvider = new JavaElementLabelProvider((int)LABEL_FLAGS);
    private SashForm sash;
    private ScrolledComposite scrollable;
    private Composite content;
    private TableViewer viewer;
    private List<ExtdocProvider> providerRanking;
    private boolean visible = true;
    private ExtdocProvider activeProvider;
    private JavaSelectionEvent activeSelection;

    @Inject
    public ExtdocView(EventBus workspaceBus, SubscriptionManager subscriptionManager, List<ExtdocProvider> providers, ExtdocPreferences preferences) {
        this.workspaceBus = workspaceBus;
        this.subscriptionManager = subscriptionManager;
        this.providers = providers;
        this.preferences = preferences;
        this.providerRanking = this.loadProviderRanking();
    }

    private List<ExtdocProvider> loadProviderRanking() {
        LinkedList<ExtdocProvider> providerRanking = new LinkedList<ExtdocProvider>();
        HashMap<String, ExtdocProvider> providerMap = this.fillProviderMap();
        List<String> providerIds = this.preferences.loadOrderedProviderIds();
        LinkedList<ExtdocProvider> remainingProviders = new LinkedList<ExtdocProvider>(this.providers);
        for (String providerName : providerIds) {
            ExtdocProvider tmpProvider = (ExtdocProvider)providerMap.get(providerName);
            if (tmpProvider == null) continue;
            providerRanking.add(tmpProvider);
            remainingProviders.remove(tmpProvider);
        }
        providerRanking.addAll(remainingProviders);
        return providerRanking;
    }

    private HashMap<String, ExtdocProvider> fillProviderMap() {
        HashMap<String, ExtdocProvider> providerMap = new HashMap<String, ExtdocProvider>();
        for (ExtdocProvider provider : this.providers) {
            providerMap.put(provider.getId(), provider);
        }
        return providerMap;
    }

    @VisibleForTesting
    public void storeProviderRanking() {
        this.preferences.storeProviderRanking(this.providerRanking);
    }

    public void createPartControl(Composite parent) {
        this.createSash(parent);
        this.createProviderOverview();
        this.createContentArea();
        this.addVisibilityListener();
        this.applyUiPreferences();
        this.workspaceBus.register((Object)this);
    }

    private void createSash(Composite parent) {
        this.sash = new SashForm(parent, 65536);
        this.sash.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.sash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtdocView.this.preferences.storeSashWeights(ExtdocView.this.sash.getWeights());
            }
        });
    }

    private void createProviderOverview() {
        this.viewer = new TableViewer((Composite)this.sash, 4);
        this.addDnDSupport();
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object first, Object second) {
                int indexFirst = ExtdocView.this.providerRanking.indexOf((ExtdocProvider)first);
                int indexSecond = ExtdocView.this.providerRanking.indexOf((ExtdocProvider)second);
                return indexFirst - indexSecond;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ExtdocProvider)element).getDescription().getName();
            }

            public Image getImage(Object element) {
                return ((ExtdocProvider)element).getDescription().getImage();
            }
        });
        this.viewer.setInput(this.providers);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExtdocProvider newProvider = (ExtdocProvider)RCPUtils.first((ISelection)event.getSelection()).orNull();
                if (newProvider == ExtdocView.this.activeProvider) {
                    return;
                }
                ExtdocView.this.activeProvider = newProvider;
                Job job = new Job(Messages.EXTDOC_UPDATE_JOB){

                    protected IStatus run(IProgressMonitor monitor) {
                        ExtdocView.this.onJavaSelection(ExtdocView.this.activeSelection);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        this.viewer.setSelection((ISelection)new StructuredSelection(Iterables.getFirst(this.providers, null)));
    }

    private void addDnDSupport() {
        Transfer[] transferTypes = new Transfer[]{ExtdocProviderTransfer.getInstance()};
        this.viewer.addDragSupport(2, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ExtdocView.this.viewer.getSelection();
                if (ExtdocProviderTransfer.getInstance().isSupportedType(event.dataType)) {
                    ExtdocProvider selectedProvider = (ExtdocProvider)selection.getFirstElement();
                    ExtdocProviderTransfer.getInstance().setExtdocProvider(selectedProvider);
                }
            }
        });
        this.viewer.addDropSupport(2, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private int newIndex;
            private int currentFeedback;

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return ExtdocProviderTransfer.getInstance().isSupportedType(transferType);
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = this.determineLocation(event) == 1 && this.isFirstProvider(event) ? 2 : 4;
                this.currentFeedback = event.feedback;
            }

            private boolean isFirstProvider(DropTargetEvent event) {
                return ExtdocView.this.providerRanking.indexOf((ExtdocProvider)this.determineTarget(event)) == 0;
            }

            public void drop(DropTargetEvent event) {
                this.newIndex = event.item != null ? ExtdocView.this.providerRanking.indexOf((ExtdocProvider)event.item.getData()) : ExtdocView.this.providerRanking.size() - 1;
                this.performDrop(event.data);
            }

            public boolean performDrop(Object data) {
                ExtdocProvider provider = (ExtdocProvider)data;
                int oldIndex = ExtdocView.this.providerRanking.indexOf(provider);
                if (this.currentFeedback == 4) {
                    ExtdocView.this.moveAfter(oldIndex, this.newIndex);
                } else {
                    ExtdocView.this.moveBefore(oldIndex, this.newIndex);
                }
                ExtdocView.this.storeProviderRanking();
                ExtdocView.this.viewer.refresh();
                return true;
            }
        });
    }

    private void move(int oldIndex, int newIndex, int moveStyle) {
        if (newIndex == oldIndex) {
            return;
        }
        if (newIndex < oldIndex) {
            ExtdocProvider tmp = this.providerRanking.remove(oldIndex);
            this.providerRanking.add(newIndex + moveStyle, tmp);
        } else {
            ExtdocProvider tmp = this.providerRanking.remove(oldIndex);
            this.providerRanking.add(newIndex - 1 + moveStyle, tmp);
        }
    }

    @VisibleForTesting
    public void moveAfter(int oldIndex, int newIndex) {
        this.move(oldIndex, newIndex, 1);
    }

    @VisibleForTesting
    public void moveBefore(int oldIndex, int newIndex) {
        this.move(oldIndex, newIndex, 0);
    }

    @VisibleForTesting
    public List<ExtdocProvider> getProviderRanking() {
        return this.providerRanking;
    }

    private void createContentArea() {
        this.scrollable = new ScrolledComposite((Composite)this.sash, 768);
        this.scrollable.getVerticalBar().setIncrement(20);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.setExpandVertical(true);
        this.content = new Composite((Composite)this.scrollable, 0);
        this.content.setLayout((Layout)new GridLayout());
        this.content.setFont(JFaceResources.getDialogFont());
        ExtdocUtils.setInfoBackgroundColor((Control)this.content);
        this.scrollable.setContent((Control)this.content);
    }

    private void applyUiPreferences() {
        this.sash.setWeights(this.preferences.loadSashWeights());
    }

    private void addVisibilityListener() {
        this.getViewSite().getPage().addPartListener((IPartListener2)new PartListener2Adapter(){

            public void partHidden(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ExtdocView.this.visible = false;
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ExtdocView.this.visible = true;
                }
            }

            private boolean isExtdocView(IWorkbenchPartReference partRef) {
                return partRef.getPart(false) == ExtdocView.this;
            }
        });
    }

    public void dispose() {
        this.workspaceBus.unregister((Object)this);
        super.dispose();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onJavaSelection(JavaSelectionEvent selection) {
        this.activeSelection = selection;
        if (this.visible && this.activeProvider != null && this.activeSelection != null) {
            try {
                this.disposeOldContentAndDisableRedrawOnContentArea();
                this.runProvider(selection);
                this.refreshAndEnableDrawContentArea();
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)("Exception during view update." + selection), (Object[])new Object[0]);
            }
        }
    }

    private void runProvider(JavaSelectionEvent selection) throws IllegalAccessException, InvocationTargetException {
        Optional<Method> opt = this.subscriptionManager.findSubscribedMethod(this.activeProvider, selection);
        if (opt.isPresent()) {
            Method method = (Method)opt.get();
            IJavaElement element = selection.getElement();
            method.invoke((Object)this.activeProvider, element, selection, this.content);
        }
    }

    private void refreshAndEnableDrawContentArea() {
        this.content.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Point size = ExtdocView.this.content.computeSize(-1, -1);
                ExtdocView.this.scrollable.setMinSize(size);
                ExtdocView.this.content.layout();
            }
        });
    }

    private void disposeOldContentAndDisableRedrawOnContentArea() {
        this.content.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExtdocUtils.disposeChildren(ExtdocView.this.content);
                ExtdocView.this.addCurrentSelectionHeader();
            }
        });
    }

    private void addCurrentSelectionHeader() {
        String text;
        IJavaElement element = this.activeSelection.getElement();
        switch (element.getElementType()) {
            case 3: 
            case 4: {
                text = element.getElementName();
                break;
            }
            case 14: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)163840L);
                break;
            }
            default: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)LABEL_FLAGS);
            }
        }
        Composite header = new Composite(this.content, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)header);
        header.setLayout((Layout)new GridLayout(2, false));
        Label img = new Label(header, 0);
        img.setImage(this.labelProvider.getImage((Object)element));
        ExtdocUtils.setInfoForegroundColor((Control)img);
        ExtdocUtils.setInfoBackgroundColor((Control)img);
        Label name = ExtdocUtils.createLabel(header, text, true);
        name.setFont(JFaceResources.getHeaderFont());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

