/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ExtdocPreferences {
    public static final String PROVIDER_RANKING = "providerRanking";
    private static final String DISABLED_PROVIDERS = "disabledProviders";
    private static final String SASH_WEIGHTS = "sashWeights";
    private final IEclipsePreferences pluginPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.extdoc.rcp");
    private final Preferences providerRankingPreferences = this.pluginPreferences.node("providerRanking");

    public void storeProviderRanking(List<ExtdocProvider> providerRanking) {
        this.clearPreferences(this.providerRankingPreferences);
        int i = 0;
        while (i < providerRanking.size()) {
            this.providerRankingPreferences.put(Integer.toString(i), providerRanking.get(i).getId());
            ++i;
        }
        this.flush();
    }

    public List<String> loadOrderedProviderIds() {
        String[] keys = this.fetchKeys(this.providerRankingPreferences);
        LinkedList<String> providerIds = new LinkedList<String>();
        int i = 0;
        while (i < keys.length) {
            String tmp = this.providerRankingPreferences.get(Integer.toString(i), null);
            if (tmp != null) {
                providerIds.add(tmp);
            } else {
                RecommendersPlugin.logWarning((String)("Loading entry for key " + i + " failed. No such entry."), (Object[])new Object[0]);
            }
            ++i;
        }
        return providerIds;
    }

    private String[] fetchKeys(Preferences node) {
        String[] keys = new String[]{};
        try {
            keys = node.keys();
        }
        catch (BackingStoreException e) {
            RecommendersPlugin.logError((Exception)((Object)e), (String)("Exception during loading the keys of: " + node.absolutePath()), (Object[])new Object[0]);
        }
        return keys;
    }

    private boolean clearPreferences(Preferences prefs) {
        try {
            prefs.clear();
            return true;
        }
        catch (BackingStoreException e) {
            RecommendersPlugin.logError((Exception)((Object)e), (String)("Caught exception while clearing the preferences : " + prefs.absolutePath()), (Object[])new Object[0]);
            return false;
        }
    }

    private String createString(String[] names) {
        if (names.length > 0) {
            String out = "";
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                out = String.valueOf(out) + "," + name;
                ++n2;
            }
            return out.substring(1);
        }
        return "";
    }

    public boolean isProviderEnabled(ExtdocProvider p) {
        String arrayString = this.pluginPreferences.get(DISABLED_PROVIDERS, "");
        String[] deactivatedProviders = arrayString.split(",");
        String providerName = p.getDescription().getName();
        String[] stringArray = deactivatedProviders;
        int n = deactivatedProviders.length;
        int n2 = 0;
        while (n2 < n) {
            String deactivatedName = stringArray[n2];
            if (deactivatedName.equals(providerName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void storeProviderEnablement(List<ExtdocProvider> providers) {
        String[] disabledProviderNames = this.getDisabledProviderNames(providers);
        String toSave = this.createString(disabledProviderNames);
        this.pluginPreferences.put(DISABLED_PROVIDERS, toSave);
        this.flush();
    }

    private String[] getDisabledProviderNames(List<ExtdocProvider> providers) {
        ArrayList<String> disabledProviders = new ArrayList<String>();
        for (ExtdocProvider p : providers) {
            if (p.isEnabled()) continue;
            disabledProviders.add(p.getDescription().getName());
        }
        return disabledProviders.toArray(new String[0]);
    }

    public int[] loadSashWeights() {
        String weightString = this.pluginPreferences.get(SASH_WEIGHTS, "1,3");
        String[] weights = weightString.split(",");
        return new int[]{Integer.parseInt(weights[0]), Integer.parseInt(weights[1])};
    }

    public void storeSashWeights(int[] weights) {
        String toSave = String.valueOf(weights[0]) + "," + weights[1];
        this.pluginPreferences.put(SASH_WEIGHTS, toSave);
        this.flush();
    }

    private boolean flush() {
        try {
            this.pluginPreferences.flush();
            return true;
        }
        catch (BackingStoreException e) {
            RecommendersPlugin.logError((Exception)((Object)e), (String)"Caught exception while saving the order of ExtdocProviders", (Object[])new Object[0]);
            return false;
        }
    }

    public boolean clearProviderRankingPreferences() {
        return this.clearPreferences(this.providerRankingPreferences);
    }
}

