/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.internal.gef.core.ContextMenuProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiSelectionContextMenuProvider
extends ContextMenuProvider {
    public MultiSelectionContextMenuProvider(IEditPartViewer viewer) {
        super(viewer);
    }

    @Override
    protected final void buildContextMenu() {
        List<EditPart> editParts = this.m_viewer.getSelectedEditParts();
        this.preprocessSelection(editParts);
        if (editParts.isEmpty()) {
            return;
        }
        if (editParts.size() == 1) {
            EditPart editPart = editParts.get(0);
            this.buildContextMenu(editPart, (IMenuManager)this);
            return;
        }
        List managers = Lists.newArrayList();
        for (EditPart editPart : editParts) {
            MenuManager manager = new MenuManager();
            this.buildContextMenu(editPart, (IMenuManager)manager);
            managers.add(manager);
        }
        MenuIntersector.merge((IMenuManager)this, managers);
    }

    protected void preprocessSelection(List<EditPart> editParts) {
    }

    protected abstract void buildContextMenu(EditPart var1, IMenuManager var2);
}

