/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.extdoc;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.extdoc.CodeSnippet;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class CodeExamples {
    private final String providerId = this.getClass().getSimpleName();
    private ITypeName type;
    private IMethodName method;
    private CodeSnippet[] examples;

    public static CodeExamples create(ITypeName type, IMethodName method, CodeSnippet ... examples) {
        CodeExamples result = new CodeExamples();
        result.type = type;
        result.method = method;
        result.examples = examples;
        result.validate();
        return result;
    }

    public CodeSnippet[] getExamples() {
        return this.examples == null ? new CodeSnippet[]{} : (CodeSnippet[])this.examples.clone();
    }

    public void validate() {
        Checks.ensureIsNotNull((Object)this.type);
        Checks.ensureIsNotNull((Object)this.method);
        Checks.ensureIsTrue((this.examples.length > 0 ? 1 : 0) != 0);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

