/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.overrides;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.SessionProcessor;
import org.eclipse.recommenders.internal.completion.rcp.ProcessableCompletionProposalComputer;
import org.eclipse.recommenders.internal.completion.rcp.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommendation;
import org.eclipse.recommenders.internal.completion.rcp.overrides.OverridesRecommender;
import org.eclipse.recommenders.rcp.RecommendersPlugin;

public class OverridesSessionProcessor
extends SessionProcessor {
    private List<OverridesRecommendation> recommendations;
    private OverridesRecommender recommender;

    @Inject
    public OverridesSessionProcessor(OverridesRecommender recommender) {
        this.recommender = recommender;
    }

    public void startSession(IRecommendersCompletionContext context) {
        try {
            this.recommender.startSession(context);
            this.recommendations = this.recommender.getRecommendations();
        }
        catch (CoreException e) {
            RecommendersPlugin.log((CoreException)e);
        }
    }

    public void process(IProcessableProposal proposal) {
        CompletionProposal cProposal = (CompletionProposal)proposal.getCoreProposal().or((Object)ProcessableCompletionProposalComputer.NULL_PROPOSAL);
        switch (cProposal.getKind()) {
            case 7: {
                String signature = String.valueOf(cProposal.getSignature()).replace('.', '/');
                String name = String.valueOf(cProposal.getName());
                String propSignature = (String.valueOf(name) + signature).replaceAll("<\\.>", "");
                for (OverridesRecommendation r : this.recommendations) {
                    String recSignature = r.method.getSignature();
                    if (!recSignature.equals(propSignature)) continue;
                    int percentage = (int)Math.rint(r.probability * 100.0);
                    int increment = 100 + percentage << 3;
                    String label = String.valueOf(percentage) + "%";
                    ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
                    mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(increment, label));
                }
                break;
            }
        }
    }
}

