/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.lifecycle;

import java.util.HashSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.lifecycle.AbstractLifecycleMappingProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;

public class WorkspaceLifecycleMappingProposal
extends AbstractLifecycleMappingProposal
implements ICompletionProposal {
    public WorkspaceLifecycleMappingProposal(IMarker marker, PluginExecutionAction action) {
        super(marker, action);
    }

    @Override
    public void run(IMarker[] markers, IProgressMonitor monitor) {
        LifecycleMappingMetadataSource mapping = LifecycleMappingFactory.getWorkspaceMetadata((boolean)true);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.addMapping(mapping, marker);
            ++n2;
        }
        LifecycleMappingFactory.writeWorkspaceMetadata((LifecycleMappingMetadataSource)mapping);
        new UpdateMavenProjectJob(new IProject[]{this.marker.getResource().getProject()}).schedule();
    }

    private void addMapping(LifecycleMappingMetadataSource mapping, IMarker marker) {
        String groupId = marker.getAttribute("groupId", "");
        String artifactId = marker.getAttribute("artifactId", "");
        String version = marker.getAttribute("version", "");
        String[] goals = new String[]{marker.getAttribute("goal", "")};
        PluginExecutionMetadata execution = this.getPluginExecutionMetadata(mapping, groupId, artifactId, version);
        if (execution == null) {
            execution = new PluginExecutionMetadata();
            execution.setSource(mapping);
            execution.setFilter(new PluginExecutionFilter(groupId, artifactId, version, new HashSet()));
            Xpp3Dom actionDom = new Xpp3Dom("action");
            actionDom.addChild(new Xpp3Dom(this.action.toString()));
            execution.setActionDom((Object)actionDom);
            mapping.addPluginExecution(execution);
        }
        String[] stringArray = goals;
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            String goal = stringArray[n2];
            execution.getFilter().addGoal(goal);
            ++n2;
        }
    }

    private PluginExecutionMetadata getPluginExecutionMetadata(LifecycleMappingMetadataSource mapping, String groupId, String artifactId, String version) {
        for (PluginExecutionMetadata execution : mapping.getPluginExecutions()) {
            PluginExecutionFilter filter = execution.getFilter();
            if (!WorkspaceLifecycleMappingProposal.eq(groupId, filter.getGroupId()) || !WorkspaceLifecycleMappingProposal.eq(artifactId, filter.getArtifactId()) || !WorkspaceLifecycleMappingProposal.eq(version, filter.getVersionRange()) || this.action != execution.getAction()) continue;
            return execution;
        }
        return null;
    }

    @Override
    public String getDisplayString() {
        String goal = this.marker.getAttribute("goal", "");
        return NLS.bind((String)Messages.LifecycleMappingProposal_workspaceIgnore_label, (Object)goal);
    }

    private static <S> boolean eq(S a, S b) {
        return a != null ? a.equals(b) : b == null;
    }

    public void apply(IDocument document) {
        this.run(this.marker);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

