/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMavenProjectsDialog
extends TitleAreaDialog
implements IMenuListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateMavenProjectsDialog.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private CheckboxTreeViewer codebaseViewer;
    private Collection<IProject> projects;
    private Button offlineModeBtn;
    private Button forceUpdateBtn;
    private Map<String, IProject> projectPaths;
    private final IProject[] initialSelection;
    private IProject[] selectedProjects;
    private boolean offlineMode;
    private boolean forceUpdateDependencies;
    private boolean updateConfiguration;
    private boolean cleanProjects;
    private boolean refreshFromLocal;
    protected String dialogTitle;
    protected String dialogMessage;
    private final Action selectTree = new Action(Messages.UpdateDepenciesDialog_selectTree){

        public void run() {
            UpdateMavenProjectsDialog.this.codebaseViewer.setSubtreeChecked((Object)UpdateMavenProjectsDialog.this.getSelection(), true);
        }
    };
    private final Action deselectTree = new Action(Messages.UpdateDepenciesDialog_deselectTree){

        public void run() {
            UpdateMavenProjectsDialog.this.codebaseViewer.setSubtreeChecked((Object)UpdateMavenProjectsDialog.this.getSelection(), false);
        }
    };
    private Button btnUpdateProjectConfiguration;
    private Button btnCleanProjects;
    private Button btnRefreshFromLocal;

    public UpdateMavenProjectsDialog(Shell parentShell, IProject[] initialSelection) {
        super(parentShell);
        this.initialSelection = initialSelection;
        this.dialogTitle = Messages.UpdateMavenProjectDialog_title;
        this.dialogMessage = Messages.UpdateMavenProjectDialog_dialogMessage;
        this.offlineMode = MavenPlugin.getMavenConfiguration().isOffline();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getDialogTitle());
    }

    private String getElePath(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            URI locationURI = project.getLocationURI();
            try {
                IFileStore store = EFS.getStore((URI)locationURI);
                File file = store.toLocalFile(0, null);
                return String.valueOf(file.toString()) + SEPARATOR;
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label lblAvailable = new Label(container, 0);
        lblAvailable.setText(Messages.UpdateDepenciesDialog_availableCodebasesLabel);
        lblAvailable.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.codebaseViewer = new CheckboxTreeViewer(container, 2048);
        this.codebaseViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object element) {
                if (element instanceof Collection) {
                    return ((Collection)element).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IProject) {
                    String elePath = UpdateMavenProjectsDialog.this.getElePath(parentElement);
                    String prevPath = null;
                    ArrayList<IProject> children = new ArrayList<IProject>();
                    for (String path : UpdateMavenProjectsDialog.this.projectPaths.keySet()) {
                        if (path.length() == elePath.length() || !path.startsWith(elePath) || prevPath != null && path.startsWith(prevPath)) continue;
                        prevPath = path;
                        children.add(UpdateMavenProjectsDialog.this.getProject(path));
                    }
                    return children.toArray();
                }
                if (parentElement instanceof Collection) {
                    return ((Collection)parentElement).toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                String elePath = UpdateMavenProjectsDialog.this.getElePath(element);
                String prevPath = null;
                for (String path : UpdateMavenProjectsDialog.this.projectPaths.keySet()) {
                    if (elePath.length() == path.length() || !elePath.startsWith(path) || prevPath != null && prevPath.length() >= path.length()) continue;
                    prevPath = path;
                }
                return prevPath == null ? UpdateMavenProjectsDialog.this.projects : UpdateMavenProjectsDialog.this.getProject(prevPath);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IProject) {
                    String elePath = UpdateMavenProjectsDialog.this.getElePath(element);
                    for (String path : UpdateMavenProjectsDialog.this.projectPaths.keySet()) {
                        if (elePath.length() == path.length() || !path.startsWith(elePath)) continue;
                        return true;
                    }
                } else if (element instanceof Collection) {
                    return !((Collection)element).isEmpty();
                }
                return false;
            }
        });
        this.codebaseViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return MavenImages.createOverlayImage("project-mlabel.gif", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"), MavenImages.MAVEN_OVERLAY, 0);
            }

            public String getText(Object element) {
                return element instanceof IProject ? ((IProject)element).getName() : "";
            }
        });
        this.projects = this.getMavenCodebases();
        this.codebaseViewer.setInput(this.projects);
        this.codebaseViewer.expandAll();
        IProject[] iProjectArray = this.initialSelection;
        int n = this.initialSelection.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.codebaseViewer.setSubtreeChecked((Object)project, true);
            ++n2;
        }
        if (this.initialSelection.length > 0) {
            this.codebaseViewer.reveal((Object)this.initialSelection[0]);
        }
        Tree tree = this.codebaseViewer.getTree();
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 300;
        gd.widthHint = 300;
        tree.setLayoutData((Object)gd);
        Composite selectionActionComposite = new Composite(container, 0);
        selectionActionComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_selectionActionComposite = new GridLayout(1, false);
        gl_selectionActionComposite.marginWidth = 0;
        gl_selectionActionComposite.marginHeight = 0;
        selectionActionComposite.setLayout((Layout)gl_selectionActionComposite);
        Button selectAllBtn = new Button(selectionActionComposite, 0);
        selectAllBtn.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        selectAllBtn.setText(Messages.UpdateDepenciesDialog_selectAll);
        selectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : UpdateMavenProjectsDialog.this.projects) {
                    UpdateMavenProjectsDialog.this.codebaseViewer.setSubtreeChecked((Object)project, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deselectAllBtn = new Button(selectionActionComposite, 0);
        deselectAllBtn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        deselectAllBtn.setText(Messages.UpdateDepenciesDialog_deselectAll);
        deselectAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (IProject project : UpdateMavenProjectsDialog.this.projects) {
                    UpdateMavenProjectsDialog.this.codebaseViewer.setSubtreeChecked((Object)project, false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button expandAllBtn = new Button(selectionActionComposite, 0);
        expandAllBtn.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        expandAllBtn.setText(Messages.UpdateDepenciesDialog_expandAll);
        expandAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpdateMavenProjectsDialog.this.codebaseViewer.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button collapseAllBtn = new Button(selectionActionComposite, 0);
        collapseAllBtn.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        collapseAllBtn.setText(Messages.UpdateDepenciesDialog_collapseAll);
        collapseAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpdateMavenProjectsDialog.this.codebaseViewer.collapseAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite optionsComposite = new Composite(container, 0);
        optionsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        GridLayout gl_optionsComposite = new GridLayout(1, false);
        gl_optionsComposite.marginHeight = 0;
        gl_optionsComposite.marginWidth = 0;
        optionsComposite.setLayout((Layout)gl_optionsComposite);
        this.offlineModeBtn = new Button(optionsComposite, 32);
        this.offlineModeBtn.setText(Messages.UpdateDepenciesDialog_offline);
        this.offlineModeBtn.setSelection(this.offlineMode);
        Button btnCheckButton = new Button(optionsComposite, 32);
        btnCheckButton.setEnabled(false);
        btnCheckButton.setSelection(true);
        btnCheckButton.setText(Messages.UpdateMavenProjectDialog_btnCheckButton_text);
        this.forceUpdateBtn = new Button(optionsComposite, 32);
        GridData gd_forceUpdateBtn = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_forceUpdateBtn.horizontalIndent = 15;
        this.forceUpdateBtn.setLayoutData((Object)gd_forceUpdateBtn);
        this.forceUpdateBtn.setText(Messages.UpdateDepenciesDialog_forceUpdate);
        this.btnUpdateProjectConfiguration = new Button(optionsComposite, 32);
        this.btnUpdateProjectConfiguration.setSelection(true);
        this.btnUpdateProjectConfiguration.setText(Messages.UpdateMavenProjectDialog_btnUpdateProjectConfiguration_text);
        this.btnRefreshFromLocal = new Button(optionsComposite, 32);
        this.btnRefreshFromLocal.setSelection(true);
        this.btnRefreshFromLocal.setText(Messages.UpdateMavenProjectsDialog_btnRefreshFromLocal_text);
        this.btnCleanProjects = new Button(optionsComposite, 32);
        this.btnCleanProjects.setSelection(true);
        this.btnCleanProjects.setText(Messages.UpdateMavenProjectDialog_btnCleanProjects_text);
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        this.createMenu();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        Object[] obj = this.codebaseViewer.getCheckedElements();
        IProject[] projects = new IProject[obj.length];
        int i = 0;
        while (i < obj.length) {
            projects[i] = (IProject)obj[i];
            ++i;
        }
        this.selectedProjects = projects;
        this.offlineMode = this.offlineModeBtn.getSelection();
        this.forceUpdateDependencies = this.forceUpdateBtn.getSelection();
        this.updateConfiguration = this.btnUpdateProjectConfiguration.getSelection();
        this.cleanProjects = this.btnCleanProjects.getSelection();
        this.refreshFromLocal = this.btnRefreshFromLocal.getSelection();
        super.okPressed();
    }

    private Collection<IProject> getMavenCodebases() {
        this.projectPaths = new TreeMap<String, IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                String path;
                if (project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && project.getLocationURI() != null && (path = this.getElePath(project)) != null) {
                    this.projectPaths.put(path, project);
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            ++n2;
        }
        if (this.projectPaths.isEmpty()) {
            return Collections.emptyList();
        }
        this.projects = new ArrayList<IProject>();
        String previous = this.projectPaths.keySet().iterator().next();
        UpdateMavenProjectsDialog.addProject(this.projects, previous);
        for (String path : this.projectPaths.keySet()) {
            if (path.startsWith(previous)) continue;
            previous = path;
            IProject project = this.getProject(path);
            if (project == null) continue;
            this.projects.add(project);
        }
        return this.projects;
    }

    private static void addProject(Collection<IProject> projects, String location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] iContainerArray = root.findContainersForLocationURI(new File(location).toURI());
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container instanceof IProject) {
                projects.add((IProject)container);
                break;
            }
            ++n2;
        }
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects;
    }

    public boolean isOffline() {
        return this.offlineMode;
    }

    public boolean isForceUpdateDependencies() {
        return this.forceUpdateDependencies;
    }

    public boolean isUpdateConfiguration() {
        return this.updateConfiguration;
    }

    public boolean isCleanProjects() {
        return this.cleanProjects;
    }

    public boolean isRefreshFromLocal() {
        return this.refreshFromLocal;
    }

    private IProject getProject(String path) {
        return this.projectPaths.get(path);
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu contextMenu = menuMgr.createContextMenu(this.codebaseViewer.getControl());
        menuMgr.addMenuListener((IMenuListener)this);
        this.codebaseViewer.getControl().setMenu(contextMenu);
        menuMgr.setRemoveAllWhenShown(true);
    }

    private IProject getSelection() {
        ISelection selection = this.codebaseViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IProject)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.codebaseViewer.getSelection().isEmpty()) {
            return;
        }
        if (this.codebaseViewer.getSelection() instanceof IStructuredSelection) {
            manager.add((IAction)this.selectTree);
            manager.add((IAction)this.deselectTree);
        }
    }

    public String getDialogTitle() {
        if (this.dialogTitle == null) {
            this.dialogTitle = "";
        }
        return this.dialogTitle;
    }

    public String getDialogMessage() {
        if (this.dialogMessage == null) {
            this.dialogMessage = "";
        }
        return this.dialogMessage;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }
}

