/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.utils.GenericEnumerationUtils;
import org.eclipse.recommenders.utils.rcp.internal.PreferencesInitalizer;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class UUIDHelper {
    public static String getUUID() {
        Optional<String> uuid = UUIDHelper.lookupUUIDFromStore();
        if (uuid.isPresent()) {
            return (String)uuid.get();
        }
        String newUuid = UUIDHelper.generateGlobalUUID();
        UUIDHelper.storeUUID(newUuid);
        return newUuid;
    }

    private static Optional<String> lookupUUIDFromStore() {
        RecommendersUtilsPlugin plugin = RecommendersUtilsPlugin.getDefault();
        IPreferenceStore prefStore = plugin.getPreferenceStore();
        String uuid = prefStore.getString(PreferencesInitalizer.PROP_UUID);
        if (Strings.isNullOrEmpty((String)uuid)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)uuid);
    }

    private static void storeUUID(String uuid) {
        RecommendersUtilsPlugin plugin = RecommendersUtilsPlugin.getDefault();
        IPreferenceStore prefStore = plugin.getPreferenceStore();
        prefStore.putValue(PreferencesInitalizer.PROP_UUID, uuid);
    }

    public static String generateGlobalUUID() {
        Optional<String> uuid = UUIDHelper.generateUUIDFromMacAddress();
        if (!uuid.isPresent()) {
            return UUID.randomUUID().toString();
        }
        return (String)uuid.get();
    }

    private static Optional<String> generateUUIDFromMacAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface net : GenericEnumerationUtils.iterable(e)) {
                String uuid;
                byte[] mac = net.getHardwareAddress();
                if (ArrayUtils.isEmpty((byte[])mac) || Strings.isNullOrEmpty((String)(uuid = UUID.nameUUIDFromBytes(mac).toString()))) continue;
                return Optional.fromNullable((Object)uuid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.absent();
    }

    public static String generateUID() {
        return UUID.randomUUID().toString();
    }
}

