/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.beans.Beans;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractRepositoryQueryPage
extends WizardPage
implements ITaskSearchPage {
    private ITaskSearchPageContainer searchContainer;
    private final TaskRepository taskRepository;
    private final IRepositoryQuery query;

    public AbstractRepositoryQueryPage(String pageName, TaskRepository taskRepository, IRepositoryQuery query) {
        super(pageName);
        if (!Beans.isDesignTime()) {
            Assert.isNotNull((Object)taskRepository);
        }
        this.taskRepository = taskRepository;
        this.query = query;
        this.setTitle(Messages.AbstractRepositoryQueryPage_Enter_query_parameters);
        this.setDescription(Messages.AbstractRepositoryQueryPage_If_attributes_are_blank_or_stale_press_the_Update_button);
        if (!Beans.isDesignTime()) {
            this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        }
        this.setPageComplete(false);
    }

    public AbstractRepositoryQueryPage(String pageName, TaskRepository taskRepository) {
        this(pageName, taskRepository, null);
    }

    public IRepositoryQuery getQuery() {
        return this.query;
    }

    public abstract String getQueryTitle();

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        String queryTitle = this.getQueryTitle();
        if (queryTitle == null || queryTitle.equals("")) {
            this.setMessage(Messages.AbstractRepositoryQueryPage_Please_specify_a_title_for_the_query);
            return false;
        }
        Set queries = TasksUiInternal.getTaskList().getQueries();
        Set categories = TasksUiInternal.getTaskList().getCategories();
        String oldSummary = null;
        if (this.query != null) {
            oldSummary = this.query.getSummary();
        }
        if (oldSummary == null || !queryTitle.equals(oldSummary)) {
            for (AbstractTaskCategory category : categories) {
                if (!queryTitle.equals(category.getSummary())) continue;
                this.setMessage(Messages.AbstractRepositoryQueryPage_A_category_with_this_name_already_exists, 3);
                return false;
            }
            for (RepositoryQuery repositoryQuery : queries) {
                if (this.query != null && this.query.equals(repositoryQuery) || !queryTitle.equals(repositoryQuery.getSummary()) || !repositoryQuery.getRepositoryUrl().equals(this.getTaskRepository().getRepositoryUrl())) continue;
                this.setMessage(Messages.AbstractRepositoryQueryPage_A_query_with_this_name_already_exists, 2);
                return true;
            }
        }
        this.setMessage(null);
        return true;
    }

    public IRepositoryQuery createQuery() {
        IRepositoryQuery query = TasksUi.getRepositoryModel().createRepositoryQuery(this.getTaskRepository());
        this.applyTo(query);
        return query;
    }

    public abstract void applyTo(IRepositoryQuery var1);

    public void saveState() {
    }

    @Override
    public void setContainer(ITaskSearchPageContainer container) {
        this.searchContainer = container;
    }

    public boolean inSearchContainer() {
        return this.searchContainer != null;
    }

    @Override
    public boolean performSearch() {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind());
        if (connector != null) {
            try {
                SearchUtil.runSearchQuery(TasksUiInternal.getTaskList(), this.taskRepository, this.createQuery(), true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                SearchUtil.runSearchQuery(TasksUiInternal.getTaskList(), this.taskRepository, this.getQuery(), true);
            }
        }
        return true;
    }

    public void setControlsEnabled(boolean enabled) {
        this.setControlsEnabled(this.getControl(), enabled);
    }

    private void setControlsEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                childControl.setEnabled(enabled);
                this.setControlsEnabled(childControl, enabled);
                ++n2;
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public ITaskSearchPageContainer getSearchContainer() {
        return this.searchContainer;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }
}

