/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractTaskEditorPart
extends AbstractFormPart {
    protected static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    private Control control;
    private String partName;
    private String partId;
    private AbstractTaskEditorPage taskEditorPage;
    private boolean expandVertically;
    private MaximizePartAction maximizePartAction;

    protected AbstractAttributeEditor createAttributeEditor(TaskAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        String type = attribute.getMetaData().getType();
        if (type != null) {
            AttributeEditorFactory attributeEditorFactory = this.getTaskEditorPage().getAttributeEditorFactory();
            AbstractAttributeEditor editor = attributeEditorFactory.createEditor(type, attribute);
            if (editor instanceof RichTextAttributeEditor) {
                boolean spellChecking = this.getTaskEditorPage().getAttributeEditorToolkit().hasSpellChecking(attribute);
                ((RichTextAttributeEditor)editor).setSpellCheckingEnabled(spellChecking);
            }
            return editor;
        }
        return null;
    }

    public abstract void createControl(Composite var1, FormToolkit var2);

    protected Section createSection(Composite parent, FormToolkit toolkit, int style) {
        Section section = toolkit.createSection(parent, style);
        section.setText(CommonUiUtil.toLabel((String)this.getPartName()));
        return section;
    }

    protected Section createSection(Composite parent, FormToolkit toolkit, boolean expandedState) {
        int style = 258;
        if (expandedState) {
            style |= 0x40;
        }
        return this.createSection(parent, toolkit, style);
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
    }

    public Control getControl() {
        return this.control;
    }

    public TaskDataModel getModel() {
        return this.getTaskEditorPage().getModel();
    }

    public String getPartId() {
        return this.partId;
    }

    public String getPartName() {
        return this.partName;
    }

    public TaskData getTaskData() {
        return this.getTaskEditorPage().getModel().getTaskData();
    }

    public AbstractTaskEditorPage getTaskEditorPage() {
        return this.taskEditorPage;
    }

    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        this.taskEditorPage = taskEditorPage;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    void setPartId(String partId) {
        this.partId = partId;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0) {
                Composite toolbarComposite = toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.center = true;
                toolbarComposite.setLayout((Layout)rowLayout);
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
                section.setTextClient((Control)toolbarComposite);
            }
        }
        this.setControl((Control)section);
    }

    protected boolean setSelection(ISelection selection) {
        return false;
    }

    public boolean getExpandVertically() {
        return this.expandVertically;
    }

    public void setExpandVertically(boolean expandVertically) {
        this.expandVertically = expandVertically;
    }

    protected Action getMaximizePartAction() {
        if (this.maximizePartAction == null) {
            this.maximizePartAction = new MaximizePartAction();
        }
        return this.maximizePartAction;
    }

    protected Control getLayoutControl() {
        return this.getControl();
    }

    private class MaximizePartAction
    extends Action {
        private static final String COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.maximizePart";
        private static final int SECTION_HEADER_HEIGHT = 50;
        private int originalHeight;

        public MaximizePartAction() {
            super(Messages.TaskEditorRichTextPart_Maximize, 2);
            this.originalHeight = -2;
            this.setImageDescriptor(CommonImages.PART_MAXIMIZE);
            this.setToolTipText(Messages.TaskEditorRichTextPart_Maximize);
            this.setActionDefinitionId(COMMAND_ID);
            this.setChecked(false);
        }

        public void run() {
            int heightHint;
            Control control;
            if (AbstractTaskEditorPart.this.getControl() instanceof Section && !((Section)AbstractTaskEditorPart.this.getControl()).isExpanded()) {
                CommonFormUtil.setExpanded((ExpandableComposite)((Section)AbstractTaskEditorPart.this.getControl()), (boolean)true);
            }
            if ((control = AbstractTaskEditorPart.this.getLayoutControl()) == null || !(control.getLayoutData() instanceof GridData)) {
                return;
            }
            GridData gd = (GridData)control.getLayoutData();
            if (this.originalHeight == -2) {
                this.originalHeight = gd.heightHint;
            }
            if (gd.heightHint == (heightHint = this.isChecked() ? AbstractTaskEditorPart.this.getManagedForm().getForm().getClientArea().height - 50 : this.originalHeight)) {
                return;
            }
            gd.heightHint = heightHint;
            gd.minimumHeight = heightHint;
            if (gd.widthHint == -1) {
                gd.widthHint = 300;
            }
            AbstractTaskEditorPart.this.getTaskEditorPage().reflow();
            CommonFormUtil.ensureVisible((Control)control);
        }
    }
}

