/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.decorators.ProxyShortListIterator;

public final class UnmodifiableShortListIterator
extends ProxyShortListIterator {
    private ShortListIterator proxied = null;

    UnmodifiableShortListIterator(ShortListIterator iterator) {
        this.proxied = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    public void add(short value) {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    public void set(short value) {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    protected ShortListIterator getListIterator() {
        return this.proxied;
    }

    public static final ShortListIterator wrap(ShortListIterator iterator) {
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof UnmodifiableShortListIterator) {
            return iterator;
        }
        return new UnmodifiableShortListIterator(iterator);
    }
}

