/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import org.apache.commons.collections.primitives.CharIterator;
import org.apache.commons.collections.primitives.decorators.ProxyCharIterator;

public final class UnmodifiableCharIterator
extends ProxyCharIterator {
    private CharIterator proxied = null;

    UnmodifiableCharIterator(CharIterator iterator) {
        this.proxied = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This CharIterator is not modifiable.");
    }

    @Override
    protected CharIterator getIterator() {
        return this.proxied;
    }

    public static final CharIterator wrap(CharIterator iterator) {
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof UnmodifiableCharIterator) {
            return iterator;
        }
        return new UnmodifiableCharIterator(iterator);
    }
}

