/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.adapters.IteratorShortIterator;
import org.apache.commons.collections.primitives.adapters.ShortCollectionCollection;

abstract class AbstractCollectionShortCollection
implements ShortCollection {
    protected AbstractCollectionShortCollection() {
    }

    @Override
    public boolean add(short element) {
        return this.getCollection().add(new Short(element));
    }

    @Override
    public boolean addAll(ShortCollection c) {
        return this.getCollection().addAll(ShortCollectionCollection.wrap(c));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(short element) {
        return this.getCollection().contains(new Short(element));
    }

    @Override
    public boolean containsAll(ShortCollection c) {
        return this.getCollection().containsAll(ShortCollectionCollection.wrap(c));
    }

    public String toString() {
        return this.getCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    public ShortIterator iterator() {
        return IteratorShortIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(short element) {
        return this.getCollection().remove(new Short(element));
    }

    @Override
    public boolean removeAll(ShortCollection c) {
        return this.getCollection().removeAll(ShortCollectionCollection.wrap(c));
    }

    @Override
    public boolean retainAll(ShortCollection c) {
        return this.getCollection().retainAll(ShortCollectionCollection.wrap(c));
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public short[] toArray() {
        Object[] src = this.getCollection().toArray();
        short[] dest = new short[src.length];
        int i = 0;
        while (i < src.length) {
            dest[i] = ((Number)src[i]).shortValue();
            ++i;
        }
        return dest;
    }

    @Override
    public short[] toArray(short[] dest) {
        Object[] src = this.getCollection().toArray();
        if (dest.length < src.length) {
            dest = new short[src.length];
        }
        int i = 0;
        while (i < src.length) {
            dest[i] = ((Number)src[i]).shortValue();
            ++i;
        }
        return dest;
    }

    protected abstract Collection getCollection();
}

