/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractLongCollection;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.LongList;
import org.apache.commons.collections.primitives.LongListIterator;

public abstract class RandomAccessLongList
extends AbstractLongCollection
implements LongList {
    private int _modCount = 0;

    protected RandomAccessLongList() {
    }

    @Override
    public abstract long get(int var1);

    @Override
    public abstract int size();

    @Override
    public long removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long set(int index, long element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, long element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(long element) {
        this.add(this.size(), element);
        return true;
    }

    @Override
    public boolean addAll(int index, LongCollection collection) {
        boolean modified = false;
        LongIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    @Override
    public int indexOf(long element) {
        int i = 0;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long element) {
        LongListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    @Override
    public LongIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(int index) {
        return new RandomAccessLongListIterator(this, index);
    }

    @Override
    public LongList subList(int fromIndex, int toIndex) {
        return new RandomAccessLongSubList(this, fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof LongList) {
            LongList thatList = (LongList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            LongIterator thatIter = thatList.iterator();
            LongIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            long val = iter.next();
            hash = 31 * hash + (int)(val ^ val >>> 32);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    private static class ComodChecker {
        private RandomAccessLongList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessLongList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessLongList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }

    protected static class RandomAccessLongListIterator
    extends ComodChecker
    implements LongListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessLongListIterator(RandomAccessLongList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public long next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        @Override
        public long previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            long val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        @Override
        public void add(long value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        @Override
        public void set(long value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    protected static class RandomAccessLongSubList
    extends RandomAccessLongList
    implements LongList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessLongList _list = null;
        private ComodChecker _comod = null;

        RandomAccessLongSubList(RandomAccessLongList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        @Override
        public long get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        @Override
        public long removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            long val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        @Override
        public long set(int index, long element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            long val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        @Override
        public void add(int index, long element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }
}

