/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatIterator;

public abstract class AbstractFloatCollection
implements FloatCollection {
    @Override
    public abstract FloatIterator iterator();

    @Override
    public abstract int size();

    protected AbstractFloatCollection() {
    }

    @Override
    public boolean add(float element) {
        throw new UnsupportedOperationException("add(float) is not supported.");
    }

    @Override
    public boolean addAll(FloatCollection c) {
        boolean modified = false;
        FloatIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(float element) {
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(FloatCollection c) {
        FloatIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(float element) {
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(FloatCollection c) {
        boolean modified = false;
        FloatIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(FloatCollection c) {
        boolean modified = false;
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        int i = 0;
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public float[] toArray(float[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        FloatIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

