/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;

public abstract class AbstractByteCollection
implements ByteCollection {
    @Override
    public abstract ByteIterator iterator();

    @Override
    public abstract int size();

    protected AbstractByteCollection() {
    }

    @Override
    public boolean add(byte element) {
        throw new UnsupportedOperationException("add(byte) is not supported.");
    }

    @Override
    public boolean addAll(ByteCollection c) {
        boolean modified = false;
        ByteIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.add(iter.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean contains(byte element) {
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(ByteCollection c) {
        ByteIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(byte element) {
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != element) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(ByteCollection c) {
        boolean modified = false;
        ByteIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= this.removeElement(iter.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(ByteCollection c) {
        boolean modified = false;
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.next())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int i = 0;
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public byte[] toArray(byte[] a) {
        if (a.length < this.size()) {
            return this.toArray();
        }
        int i = 0;
        ByteIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i] = iter.next();
            ++i;
        }
        return a;
    }
}

