/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.archive;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.eclipse.recommenders.utils.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingModelArchive<K, M>
implements IModelArchive<K, M> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private GenericKeyedObjectPool pool;
    private IModelFactory<K, M> factory;
    private Map<M, K> objects = Maps.newHashMap();

    @Inject
    public PoolingModelArchive(IModelFactory<K, M> factory) {
        this.factory = (IModelFactory)Checks.ensureIsNotNull(factory);
        this.pool = this.createPool();
    }

    private GenericKeyedObjectPool createPool() {
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new PoolFactory());
        pool.setMaxTotal(10);
        pool.setMaxIdle(3);
        pool.setWhenExhaustedAction((byte)0);
        pool.setTimeBetweenEvictionRunsMillis(300000L);
        pool.setMinEvictableIdleTimeMillis(300000L);
        return pool;
    }

    @Override
    public void open() {
        this.factory.open();
    }

    @Override
    public void close() throws IOException {
        this.factory.close();
    }

    @Override
    public boolean hasModel(K key) {
        return this.factory.hasModel(key);
    }

    @Override
    public Optional<M> acquireModel(K key) {
        try {
            Object model = this.pool.borrowObject(key);
            if (model != null) {
                this.objects.put(model, key);
            }
            return Optional.fromNullable((Object)model);
        }
        catch (Exception e) {
            this.log.error("Exception while loading model for key '" + key + "'" + e.getMessage(), (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    public void releaseModel(M model) {
        try {
            if (this.objects.containsKey(model)) {
                K key = this.objects.get(model);
                this.pool.returnObject(key, model);
            }
        }
        catch (Exception e) {
            this.log.error("Exception while releasing model'" + model + "'", (Throwable)e);
        }
    }

    private class PoolFactory
    implements KeyedPoolableObjectFactory {
        private PoolFactory() {
        }

        public boolean validateObject(Object key, Object obj) {
            return PoolingModelArchive.this.factory.validateModel(key, obj);
        }

        public void passivateObject(Object key, Object obj) throws Exception {
            PoolingModelArchive.this.factory.passivateModel(key, obj);
        }

        public Object makeObject(Object key) throws Exception {
            return PoolingModelArchive.this.factory.createModel(key);
        }

        public void destroyObject(Object key, Object obj) throws Exception {
            PoolingModelArchive.this.factory.destroyModel(key, obj);
        }

        public void activateObject(Object key, Object obj) throws Exception {
            PoolingModelArchive.this.factory.activateModel(key, obj);
        }
    }
}

