/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.internal.launch.MavenLaunchPlugin;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchUtils {
    private static final Logger log = LoggerFactory.getLogger(MavenLaunchUtils.class);

    public static MavenRuntime getMavenRuntime(ILaunchConfiguration configuration) throws CoreException {
        String location;
        MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
        MavenRuntime runtime = runtimeManager.getRuntime(location = configuration.getAttribute("M2_RUNTIME", ""));
        if (runtime == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.launching", -1, NLS.bind((String)Messages.MavenLaunchUtils_error_no_maven_install, (Object)location), null));
        }
        return runtime;
    }

    public static String getCliResolver(MavenRuntime runtime) throws CoreException {
        String runtimeVersion = runtime.getVersion();
        String jarname = runtimeVersion.startsWith("3.") ? "org.eclipse.m2e.cliresolver30.jar" : "org.eclipse.m2e.cliresolver.jar";
        return MavenLaunchUtils.getBundleEntry(MavenLaunchPlugin.getDefault().getBundle(), jarname);
    }

    public static String getBundleEntry(Bundle bundle, String entryPath) throws CoreException {
        URL url = bundle.getEntry(entryPath);
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            URI fileURI = new URI(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPath(), fileURL.getQuery());
            return new File(fileURI).getCanonicalPath();
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.launching", -1, ex.getMessage(), (Throwable)ex));
        }
    }

    public static void addUserComponents(ILaunchConfiguration configuration, IMavenLauncherConfiguration collector) throws CoreException {
        List list = configuration.getAttribute("M2_FORCED_COMPONENTS_LIST", new ArrayList());
        if (list == null) {
            return;
        }
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMaven maven = MavenPlugin.getMaven();
        for (String gav : list) {
            String version;
            String artifactId;
            StringTokenizer st = new StringTokenizer(gav, ":");
            String groupId = st.nextToken();
            IMavenProjectFacade facade = projectManager.getMavenProject(groupId, artifactId = st.nextToken(), version = st.nextToken());
            if (facade != null) {
                collector.addProjectEntry(facade);
                continue;
            }
            String name = String.valueOf(groupId) + ":" + artifactId + ":" + version;
            try {
                Artifact artifact = maven.resolve(groupId, artifactId, version, "jar", null, null, null);
                File file = artifact.getFile();
                if (file == null) continue;
                collector.addArchiveEntry(file.getAbsolutePath());
            }
            catch (CoreException ex) {
                log.error("Artifact not found " + name, (Throwable)ex);
            }
        }
    }
}

