/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreeWayDiffEntry {
    private static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());
    ChangeType changeType;
    AbbreviatedObjectId baseId;
    AbbreviatedObjectId remoteId;
    private String path;
    private Direction direction;
    private AbbreviatedObjectId localId;
    private boolean isTree = false;

    ThreeWayDiffEntry() {
    }

    public static List<ThreeWayDiffEntry> scan(TreeWalk walk) throws IOException {
        if (walk.getTreeCount() != 3) {
            throw new IllegalArgumentException("TreeWalk need to have exactly three trees");
        }
        if (walk.isRecursive()) {
            throw new IllegalArgumentException("TreeWalk shouldn't be recursive.");
        }
        ArrayList<ThreeWayDiffEntry> r = new ArrayList<ThreeWayDiffEntry>();
        MutableObjectId idBuf = new MutableObjectId();
        while (walk.next()) {
            boolean remoteIsMissing;
            ThreeWayDiffEntry e = new ThreeWayDiffEntry();
            walk.getObjectId(idBuf, 0);
            e.localId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            walk.getObjectId(idBuf, 1);
            e.baseId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            walk.getObjectId(idBuf, 2);
            e.remoteId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
            boolean localSameAsBase = e.localId.equals((Object)e.baseId);
            if (!A_ZERO.equals((Object)e.localId) && localSameAsBase && e.baseId.equals((Object)e.remoteId)) continue;
            e.path = walk.getPathString();
            boolean localIsMissing = walk.getFileMode(0) == FileMode.MISSING;
            boolean baseIsMissing = walk.getFileMode(1) == FileMode.MISSING;
            boolean bl = remoteIsMissing = walk.getFileMode(2) == FileMode.MISSING;
            if (localIsMissing || baseIsMissing || remoteIsMissing) {
                if (!localIsMissing && baseIsMissing && remoteIsMissing) {
                    e.direction = Direction.OUTGOING;
                    e.changeType = ChangeType.ADD;
                } else if (localIsMissing && baseIsMissing && !remoteIsMissing) {
                    e.direction = Direction.INCOMING;
                    e.changeType = ChangeType.ADD;
                } else if (!localIsMissing && !baseIsMissing && remoteIsMissing) {
                    e.direction = Direction.INCOMING;
                    e.changeType = ChangeType.DELETE;
                } else if (localIsMissing && !baseIsMissing && !remoteIsMissing) {
                    e.direction = Direction.OUTGOING;
                    e.changeType = ChangeType.DELETE;
                } else {
                    e.direction = Direction.CONFLICTING;
                    e.changeType = ChangeType.MODIFY;
                }
            } else {
                e.direction = localSameAsBase && !e.localId.equals((Object)e.remoteId) ? Direction.INCOMING : (e.remoteId.equals((Object)e.baseId) && !e.remoteId.equals((Object)e.localId) ? Direction.OUTGOING : Direction.CONFLICTING);
                e.changeType = ChangeType.MODIFY;
            }
            r.add(e);
            if (!walk.isSubtree()) continue;
            e.isTree = true;
            walk.enterSubtree();
        }
        return r;
    }

    public AbbreviatedObjectId getBaseId() {
        return this.baseId;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isTree() {
        return this.isTree;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public AbbreviatedObjectId getLocalId() {
        return this.localId;
    }

    public AbbreviatedObjectId getRemoteId() {
        return this.remoteId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ThreeDiffEntry[");
        buf.append((Object)this.changeType).append(" ").append(this.path);
        buf.append("]");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADD,
        MODIFY,
        DELETE,
        IN_SYNC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INCOMING,
        OUTGOING,
        CONFLICTING;

    }
}

