/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class MergeOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private MergeStrategy mergeStrategy;
    private MergeResult mergeResult;

    public MergeOperation(Repository repository, String refName) {
        this.repository = repository;
        this.refName = refName;
    }

    public MergeOperation(Repository repository, String refName, String mergeStrategy) {
        this.repository = repository;
        this.refName = refName;
        if (mergeStrategy != null) {
            this.mergeStrategy = MergeStrategy.get((String)mergeStrategy);
        }
    }

    public void execute(IProgressMonitor m) throws CoreException {
        if (this.mergeResult != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor mymonitor) throws CoreException {
                block14: {
                    validProjects = ProjectUtil.getValidOpenProjects(MergeOperation.access$0(MergeOperation.this));
                    mymonitor.beginTask(NLS.bind((String)CoreText.MergeOperation_ProgressMerge, (Object)MergeOperation.access$1(MergeOperation.this)), 3);
                    git = new Git(MergeOperation.access$0(MergeOperation.this));
                    mymonitor.worked(1);
                    try {
                        ref = MergeOperation.access$0(MergeOperation.this).getRef(MergeOperation.access$1(MergeOperation.this));
                        merge = ref != null ? git.merge().include(ref) : git.merge().include((AnyObjectId)ObjectId.fromString((String)MergeOperation.access$1(MergeOperation.this)));
                    }
                    catch (IOException e) {
                        throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
                    }
                    if (MergeOperation.access$2(MergeOperation.this) != null) {
                        merge.setStrategy(MergeOperation.access$2(MergeOperation.this));
                    }
                    try {
                        try {
                            MergeOperation.access$3(MergeOperation.this, merge.call());
                            mymonitor.worked(1);
                            if (MergeResult.MergeStatus.FAILED.equals((Object)MergeOperation.access$4(MergeOperation.this).getMergeStatus())) {
                                throw new TeamException(MergeOperation.access$4(MergeOperation.this).toString());
                            }
                            if (MergeResult.MergeStatus.NOT_SUPPORTED.equals((Object)MergeOperation.access$4(MergeOperation.this).getMergeStatus())) {
                                throw new TeamException((IStatus)new Status(1, Activator.getPluginId(), MergeOperation.access$4(MergeOperation.this).toString()));
                            }
                            break block14;
                        }
                        catch (NoHeadException e) {
                            throw new TeamException(CoreText.MergeOperation_MergeFailedNoHead, (Throwable)e);
                        }
                        catch (ConcurrentRefUpdateException e) {
                            throw new TeamException(CoreText.MergeOperation_MergeFailedRefUpdate, (Throwable)e);
                        }
                        catch (CheckoutConflictException e) {
                            builder = new StringBuilder();
                            ** for (f : e.getConflictingPaths())
                        }
lbl-1000:
                        // 1 sources

                        {
                            builder.append("\n");
                            builder.append(f);
                            continue;
                        }
lbl35:
                        // 1 sources

                        throw new TeamException((IStatus)new Status(1, Activator.getPluginId(), MessageFormat.format(CoreText.MergeOperation_CheckoutConflict, new Object[]{builder.toString()})));
                        catch (GitAPIException e) {
                            throw new TeamException(e.getLocalizedMessage(), e.getCause());
                        }
                    }
                    finally {
                        ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(mymonitor, 1));
                        mymonitor.done();
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    public MergeResult getResult() {
        return this.mergeResult;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static /* synthetic */ Repository access$0(MergeOperation mergeOperation) {
        return mergeOperation.repository;
    }

    static /* synthetic */ String access$1(MergeOperation mergeOperation) {
        return mergeOperation.refName;
    }

    static /* synthetic */ MergeStrategy access$2(MergeOperation mergeOperation) {
        return mergeOperation.mergeStrategy;
    }

    static /* synthetic */ void access$3(MergeOperation mergeOperation, MergeResult mergeResult) {
        mergeOperation.mergeResult = mergeResult;
    }

    static /* synthetic */ MergeResult access$4(MergeOperation mergeOperation) {
        return mergeOperation.mergeResult;
    }
}

