/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.Team;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static final String GITIGNORE_NAME = ".gitignore";
    private static int INTERESTING_CHANGES = 323840;
    private final Repository repository;
    private final Collection<String> filesToUpdate;
    private final Collection<IResource> resourcesToUpdate;
    private boolean gitIgnoreChanged = false;

    public GitResourceDeltaVisitor(Repository repository) {
        this.repository = repository;
        this.filesToUpdate = new HashSet<String>();
        this.resourcesToUpdate = new HashSet<IResource>();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (Team.isIgnoredHint((IResource)resource)) {
            return false;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
        if (mapping == null || mapping.getRepository() != this.repository) {
            return true;
        }
        if (resource instanceof IFolder && delta.getKind() == 1) {
            this.filesToUpdate.add(String.valueOf(mapping.getRepoRelativePath(resource)) + "/");
            this.resourcesToUpdate.add(resource);
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
            return true;
        }
        if (resource.getType() != 1) {
            return true;
        }
        if (resource.getName().equals(GITIGNORE_NAME)) {
            this.gitIgnoreChanged = true;
            return false;
        }
        String repoRelativePath = mapping.getRepoRelativePath(resource);
        if (repoRelativePath != null) {
            this.filesToUpdate.add(repoRelativePath);
        }
        this.resourcesToUpdate.add(resource);
        return true;
    }

    public Collection<IFile> getFileResourcesToUpdate() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IResource resource : this.resourcesToUpdate) {
            if (!(resource instanceof IFile)) continue;
            result.add((IFile)resource);
        }
        return result;
    }

    public Collection<IResource> getResourcesToUpdate() {
        return this.resourcesToUpdate;
    }

    public Collection<String> getFilesToUpdate() {
        return this.filesToUpdate;
    }

    public boolean getGitIgnoreChanged() {
        return this.gitIgnoreChanged;
    }
}

