/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.commons.bayesnet;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Node
implements Serializable {
    private static final long serialVersionUID = 6120294183622148914L;
    private static final Node[] EMPTY_PARENTS = new Node[0];
    private static final String[] EMPTY_STATES = new String[0];
    private static final double[] EMPTY_PROBABILITIES = new double[0];
    private final String identifier;
    private Node[] parents = EMPTY_PARENTS;
    private String[] states = EMPTY_STATES;
    private double[] probabilities = EMPTY_PROBABILITIES;

    public Node(String identifier) {
        this.identifier = identifier;
    }

    public void setStates(String[] states) {
        this.states = states;
    }

    public int numberOfStates() {
        return this.states.length;
    }

    public void setParents(Node[] parents) {
        this.parents = parents;
    }

    public int numberOfParents() {
        if (this.parents == null) {
            return 0;
        }
        return this.parents.length;
    }

    public Node[] getParents() {
        return this.parents;
    }

    public void setProbabilities(double[] probabilities) {
        this.probabilities = probabilities;
    }

    public boolean isValid() {
        if (this.parents.length > 0) {
            int parentStates = 1;
            Node[] nodeArray = this.parents;
            int n = this.parents.length;
            int n2 = 0;
            while (n2 < n) {
                Node parent = nodeArray[n2];
                parentStates *= parent.numberOfStates();
                ++n2;
            }
            if (this.probabilities.length != parentStates * this.states.length) {
                return false;
            }
        } else if (this.probabilities.length != this.states.length) {
            return false;
        }
        int i = 0;
        while (i < this.probabilities.length) {
            if (Double.isInfinite(this.probabilities[i])) {
                return false;
            }
            if (Double.isNaN(this.probabilities[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getStates() {
        return this.states;
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object arg0) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)arg0, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

