/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.wiring;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.extdoc.ClassOverrideDirectives;
import org.eclipse.recommenders.extdoc.ClassOverridePatterns;
import org.eclipse.recommenders.extdoc.ClassSelfcallDirectives;
import org.eclipse.recommenders.extdoc.MethodSelfcallDirectives;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.internal.rcp.models.archive.CachingModelArchive;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.eclipse.recommenders.internal.rcp.models.archive.MemberGsonZipPoolableModelFactory;
import org.eclipse.recommenders.internal.rcp.models.store.DefaultModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.store.IDependenciesFactory;
import org.eclipse.recommenders.internal.rcp.models.store.ModelArchiveResolutionJob;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ManualModelStoreWiring {
    private static String VERSION = "v0.5-";

    static File store(String filename) {
        Bundle bundle = FrameworkUtil.getBundle(ManualModelStoreWiring.class);
        File basedir = Platform.getStateLocation((Bundle)bundle).toFile();
        return new File(basedir, String.valueOf(VERSION) + filename);
    }

    @RecommendersModule.AutoCloseOnWorkbenchShutdown
    public static class ClassOverridesModelStore
    extends DefaultModelArchiveStore<IType, ClassOverrideDirectives> {
        static final Class gson = ClassOverrideDirectives.class;
        static final String classifier = "ovrd";

        @Inject
        public ClassOverridesModelStore(final IModelRepository repository, final JavaElementResolver jdtResolver, final IClasspathEntryInfoProvider cpeInfoProvider, final IModelRepositoryIndex searchindex) {
            super(ManualModelStoreWiring.store("class-overrides.json"), classifier, repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, classifier);
                }

                public IModelArchive newModelArchive(File file) throws IOException {
                    MemberGsonZipPoolableModelFactory loader = new MemberGsonZipPoolableModelFactory(file, gson, jdtResolver);
                    return new CachingModelArchive((IModelFactory)loader);
                }
            });
        }
    }

    @RecommendersModule.AutoCloseOnWorkbenchShutdown
    public static class ClassOverridesPatternsModelStore
    extends DefaultModelArchiveStore<IType, ClassOverridePatterns> {
        static final Class gson = ClassOverridePatterns.class;
        static final String classifier = "ovrp";

        @Inject
        public ClassOverridesPatternsModelStore(final IModelRepository repository, final JavaElementResolver jdtResolver, final IClasspathEntryInfoProvider cpeInfoProvider, final IModelRepositoryIndex searchindex) {
            super(ManualModelStoreWiring.store("class-overrides-patterns.json"), classifier, repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, classifier);
                }

                public IModelArchive newModelArchive(File file) throws IOException {
                    MemberGsonZipPoolableModelFactory loader = new MemberGsonZipPoolableModelFactory(file, gson, jdtResolver);
                    return new CachingModelArchive((IModelFactory)loader);
                }
            });
        }
    }

    @RecommendersModule.AutoCloseOnWorkbenchShutdown
    public static class ClassSelfcallsModelStore
    extends DefaultModelArchiveStore<IType, ClassSelfcallDirectives> {
        static final Class gson = ClassSelfcallDirectives.class;
        static final String classifier = "selfc";

        @Inject
        public ClassSelfcallsModelStore(final IModelRepository repository, final JavaElementResolver jdtResolver, final IClasspathEntryInfoProvider cpeInfoProvider, final IModelRepositoryIndex searchindex) {
            super(ManualModelStoreWiring.store("class-selfcalls.json"), classifier, repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, classifier);
                }

                public IModelArchive newModelArchive(File file) throws IOException {
                    MemberGsonZipPoolableModelFactory loader = new MemberGsonZipPoolableModelFactory(file, gson, jdtResolver);
                    return new CachingModelArchive((IModelFactory)loader);
                }
            });
        }
    }

    @RecommendersModule.AutoCloseOnWorkbenchShutdown
    public static class MethodSelfcallsModelStore
    extends DefaultModelArchiveStore<IMethod, MethodSelfcallDirectives> {
        static final Class gson = MethodSelfcallDirectives.class;
        static final String classifier = "selfm";

        @Inject
        public MethodSelfcallsModelStore(final IModelRepository repository, final JavaElementResolver jdtResolver, final IClasspathEntryInfoProvider cpeInfoProvider, final IModelRepositoryIndex searchindex) {
            super(ManualModelStoreWiring.store("method-selfcalls.json"), classifier, repository, new IDependenciesFactory(){

                public ModelArchiveResolutionJob newResolutionJob(ModelArchiveMetadata metadata, String classifier) {
                    return new ModelArchiveResolutionJob(metadata, cpeInfoProvider, repository, searchindex, classifier);
                }

                public IModelArchive newModelArchive(File file) throws IOException {
                    MemberGsonZipPoolableModelFactory loader = new MemberGsonZipPoolableModelFactory(file, gson, jdtResolver);
                    return new CachingModelArchive((IModelFactory)loader);
                }
            });
        }
    }
}

