/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.Events;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.OrderChangeHandler;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ExtdocModule;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProviderOverviewPart {
    private final EventBus bus;
    private final List<ExtdocProvider> providers;
    private Table table;
    private final Map<ExtdocProvider, TableItem> provider2item = Maps.newHashMap();

    @Inject
    public ProviderOverviewPart(@ExtdocModule.Extdoc EventBus bus, List<ExtdocProvider> providers) {
        this.bus = bus;
        this.providers = providers;
    }

    public void createControl(Composite parent) {
        Composite tableContent = new Composite(parent, 0);
        tableContent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.table = new Table(tableContent, 32);
        this.table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.table.addListener(13, this.createListenerThatSeparatesCheckAndSelectionEventsAndPropagatesThemToTheSelectedItem());
        for (ExtdocProvider p : this.providers) {
            TableItem item = this.createItemForProvider(p);
            this.provider2item.put(p, item);
        }
        this.addDragAndDropSupport();
    }

    private Listener createListenerThatSeparatesCheckAndSelectionEventsAndPropagatesThemToTheSelectedItem() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    event.item.notifyListeners(32, event);
                } else {
                    event.item.notifyListeners(13, event);
                }
            }
        };
    }

    private TableItem createItemForProvider(final ExtdocProvider provider) {
        final TableItem item = new TableItem(this.table, 0);
        item.setText(provider.getDescription().getName());
        item.setImage(provider.getDescription().getImage());
        item.setChecked(provider.isEnabled());
        item.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                boolean isChecked = item.getChecked();
                provider.setEnabled(isChecked);
                if (isChecked) {
                    ProviderOverviewPart.this.bus.post((Object)new Events.ProviderActivationEvent(provider));
                } else {
                    ProviderOverviewPart.this.bus.post((Object)new Events.ProviderDeactivationEvent(provider));
                }
            }
        });
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean isChecked = item.getChecked();
                if (isChecked) {
                    ProviderOverviewPart.this.bus.post((Object)new Events.ProviderSelectionEvent(provider));
                }
            }
        });
        return item;
    }

    private void addDragAndDropSupport() {
        OrderChangeHandler handler = OrderChangeHandler.enable(this.table);
        handler.addListener(new OrderChangeHandler.OrderChangedListener(){

            @Override
            public void orderChanged(int oldIndex, int newIndex) {
                ExtdocProvider providerReference = (ExtdocProvider)ProviderOverviewPart.this.providers.get(newIndex);
                ExtdocProvider movedProvider = (ExtdocProvider)ProviderOverviewPart.this.providers.remove(oldIndex);
                ProviderOverviewPart.this.providers.add(newIndex, movedProvider);
                ProviderOverviewPart.this.bus.post((Object)new Events.ProviderOrderChangedEvent(movedProvider, providerReference, oldIndex, newIndex));
                for (ExtdocProvider p : ProviderOverviewPart.this.providers) {
                    TableItem oldItem = (TableItem)ProviderOverviewPart.this.provider2item.get(p);
                    TableItem newItem = ProviderOverviewPart.this.createItemForProvider(p);
                    ProviderOverviewPart.this.provider2item.put(p, newItem);
                    newItem.setForeground(oldItem.getForeground());
                    newItem.setImage(oldItem.getImage());
                    oldItem.dispose();
                }
            }
        });
    }

    @Subscribe
    public void onEvent(Events.NewSelectionEvent e) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (ExtdocProvider p : ProviderOverviewPart.this.providers) {
                    TableItem oldItem = (TableItem)ProviderOverviewPart.this.provider2item.get(p);
                    ProviderOverviewPart.this.provider2item.put(p, ProviderOverviewPart.this.createItemForProvider(p));
                    oldItem.dispose();
                }
            }
        });
    }
}

