/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.Events;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ProviderArea;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProviderContentPart {
    private final List<ExtdocProvider> providers;
    private Composite stack;
    private StackLayout stackLayout;
    private Composite container;
    private Composite visiblePanel;
    private Composite renderingPanel;
    private ScrolledComposite scrollingComposite;
    private Composite scrolledContent;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private Map<ExtdocProvider, ProviderArea> providerAreas;
    private CLabel selectionStatus;
    private final JavaElementLabelProvider labelProvider;
    private final GridLayoutFactory defaultGridLayoutFactory = GridLayoutFactory.fillDefaults().spacing(0, 0);
    private final GridDataFactory defaultGridDataFactory = GridDataFactory.fillDefaults().grab(true, true);
    private HashMultimap<Class<? extends ExtdocProvider>, Class<?>> providerEvents;

    @Inject
    public ProviderContentPart(List<ExtdocProvider> providers) {
        this.providers = ImmutableList.copyOf(providers);
        this.labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)this.defaultGridLayoutFactory.create());
        this.createScrollingComposite();
        this.createScrolledContent();
        this.createStack();
        this.createWaitingScreen();
        this.createNewRenderingPanel();
        this.stackLayout.topControl = this.visiblePanel;
    }

    private void createScrollingComposite() {
        this.scrollingComposite = new ScrolledComposite(this.container, 768);
        this.scrollingComposite.setLayout((Layout)this.defaultGridLayoutFactory.create());
        this.scrollingComposite.setLayoutData((Object)this.defaultGridDataFactory.create());
        this.scrollingComposite.setBackground(this.container.getDisplay().getSystemColor(29));
        this.scrollingComposite.setExpandVertical(true);
        this.scrollingComposite.setExpandHorizontal(true);
        this.scrollingComposite.getVerticalBar().setIncrement(50);
        this.scrollingComposite.getHorizontalBar().setIncrement(50);
    }

    private void createScrolledContent() {
        this.scrolledContent = new Composite((Composite)this.scrollingComposite, 0);
        this.scrolledContent.setLayout((Layout)this.defaultGridLayoutFactory.create());
        this.scrolledContent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ProviderContentPart.this.resizeScrolledComposite();
            }
        });
        this.scrollingComposite.setContent((Control)this.scrolledContent);
    }

    private void resizeScrolledComposite() {
        int newWidth = this.scrolledContent.getSize().x;
        Point newSize = this.scrolledContent.computeSize(newWidth, -1);
        this.scrollingComposite.setMinHeight(newSize.y);
    }

    private void createStack() {
        this.stack = new Composite(this.scrolledContent, 0);
        this.stack.setLayoutData((Object)this.defaultGridDataFactory.create());
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
    }

    private void createWaitingScreen() {
        this.visiblePanel = new Composite(this.stack, 0);
        this.visiblePanel.setLayout((Layout)new FillLayout());
        this.visiblePanel.setBackground(this.container.getDisplay().getSystemColor(29));
        Label l = new Label(this.visiblePanel, 0);
        l.setText("waiting for selection...");
    }

    public void setFocus() {
        this.visiblePanel.setFocus();
    }

    public Composite getRenderingArea(ExtdocProvider p) {
        return this.providerAreas.get(p).getContentArea();
    }

    public void createNewRenderingPanel() {
        this.renderingPanel = new Composite(this.stack, 0);
        this.renderingPanel.setRedraw(false);
        this.renderingPanel.setBackground(this.renderingPanel.getDisplay().getSystemColor(29));
        this.renderingPanel.setLayout((Layout)this.defaultGridLayoutFactory.create());
        this.createSelectionInfoArea();
        this.providerAreas = Maps.newHashMap();
        this.providerEvents = HashMultimap.create();
        for (ExtdocProvider p : this.providers) {
            ProviderArea providerArea = new ProviderArea(p);
            providerArea.createControl(this.renderingPanel);
            this.providerAreas.put(p, providerArea);
        }
    }

    private void createSelectionInfoArea() {
        Composite selectionArea = new Composite(this.renderingPanel, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)selectionArea);
        selectionArea.setLayout((Layout)this.defaultGridLayoutFactory.create());
        selectionArea.setLayoutData((Object)this.defaultGridDataFactory.grab(true, false).create());
        this.selectionStatus = new CLabel(selectionArea, 0);
        ExtdocUtils.setInfoBackgroundColor((Control)this.selectionStatus);
        this.selectionStatus.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.selectionStatus.setBackground(selectionArea.getDisplay().getSystemColor(29));
    }

    @Subscribe
    public void onEvent(final Events.NewSelectionEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderContentPart.this.updateSelectionStatus(e.selection);
            }
        });
    }

    private void updateSelectionStatus(JavaSelectionEvent selection) {
        String text;
        IJavaElement element = selection.getElement();
        switch (element.getElementType()) {
            case 3: 
            case 4: {
                text = element.getElementName();
                break;
            }
            case 14: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)163840L);
                break;
            }
            default: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)LABEL_FLAGS);
            }
        }
        this.selectionStatus.setText(text);
        this.selectionStatus.setImage(this.labelProvider.getImage((Object)element));
    }

    @Subscribe
    public void onEvent(Events.RenderNowEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderContentPart.this.makeRenderingPanelVisible();
                ProviderContentPart.this.relayout();
                ProviderContentPart.this.scrollToTop();
                ProviderContentPart.this.renderingPanel.setRedraw(true);
            }
        });
    }

    private void scrollToTop() {
        this.scrollingComposite.setOrigin(0, 0);
    }

    private void makeRenderingPanelVisible() {
        this.stackLayout.topControl = this.renderingPanel;
        this.visiblePanel.dispose();
        this.visiblePanel = this.renderingPanel;
    }

    private void relayout() {
        this.resizeScrolledComposite();
        this.stack.layout();
    }

    @Subscribe
    public void onEvent(final Events.ProviderNotAvailableEvent e) {
        this.recordProviderEvent(e);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                if (e.hasFinishedLate) {
                    area.setStatus("provider finished without data");
                    area.showStatus();
                } else {
                    area.hide();
                }
            }
        });
    }

    private void asyncExec(Runnable runnable) {
        this.container.getDisplay().asyncExec(runnable);
    }

    @Subscribe
    public void onEvent(final Events.ProviderSelectionEvent e) {
        this.recordProviderEvent(e);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                ProviderContentPart.this.scrollingComposite.setOrigin(area.getLocation());
            }
        });
    }

    @Subscribe
    public void onEvent(final Events.ProviderFinishedEvent e) {
        if (this.hasSentFinishedEventBefore(e.provider)) {
            return;
        }
        this.recordProviderEvent(e);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                area.showContent();
            }
        });
    }

    @Subscribe
    public void onEvent(final Events.ProviderDelayedEvent e) {
        if (this.isProviderFinishedAlready(e)) {
            return;
        }
        this.recordProviderEvent(e);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                area.setStatus("provider is delayed...");
                area.showStatus();
            }
        });
    }

    private boolean isProviderFinishedAlready(Events.ProviderDelayedEvent e) {
        Class[] finishedEvents = new Class[]{Events.ProviderFinishedEvent.class, Events.ProviderFinishedLateEvent.class, Events.ProviderFailedEvent.class, Events.ProviderNotAvailableEvent.class};
        return this.providerEventsContainsAnyOf(e.provider, finishedEvents);
    }

    private boolean providerEventsContainsAnyOf(ExtdocProvider provider, Class<?> ... events) {
        Class<?>[] classArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> e = classArray[n2];
            if (this.providerEvents.containsEntry(provider.getClass(), e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Subscribe
    public void onEvent(final Events.ProviderFinishedLateEvent e) {
        if (this.hasSentFinishedEventBefore(e.provider)) {
            return;
        }
        this.recordProviderEvent(e);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                final ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                area.setStatusWithCallback("provider finished late <a>show</a>", (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        area.showContent();
                        ProviderContentPart.this.relayout();
                    }
                });
                area.showStatus();
                area.layout();
            }
        });
    }

    private void recordProviderEvent(Events.ProviderStatusEvent e) {
        this.providerEvents.put(e.provider.getClass(), e.getClass());
    }

    private boolean hasSentFinishedEventBefore(ExtdocProvider provider) {
        if (this.providerEventsContainsAnyOf(provider, Events.ProviderFinishedEvent.class, Events.ProviderFinishedLateEvent.class, Events.ProviderNotAvailableEvent.class)) {
            RecommendersPlugin.logWarning((String)"Provider %s send 'ProviderFinishedLateEvent' but send other finished events before. Rejecting further paint events.", (Object[])new Object[]{provider.getClass()});
            return true;
        }
        return false;
    }

    @Subscribe
    public void onEvent(final Events.ProviderFailedEvent e) {
        this.recordProviderEvent(e);
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                area.setStatusWithCallback("provider failed <a>show exception</a>", (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        String providerName = e.provider.getDescription().getName();
                        String dialogTitle = String.format("Extdoc Provider '%s' Failure", providerName);
                        String errorMessage = this.findFirstNonNullErrorMessage(e.throwable);
                        String rootCauseMessage = Throwables.getRootCause((Throwable)e.throwable).getMessage();
                        Status status = new Status(4, "org.eclipse.recommenders.extdoc.rcp", errorMessage, e.throwable);
                        String message = String.format("Provider %s failed with the following message: %s - %s\n\nSee error log for more details.", providerName, errorMessage, rootCauseMessage);
                        RecommendersPlugin.logError((Exception)new Exception(e.throwable), (String)message, (Object[])new Object[0]);
                        ErrorDialog.openError((Shell)ProviderContentPart.this.container.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
                    }

                    private String findFirstNonNullErrorMessage(Throwable exception) {
                        List causalChain = Throwables.getCausalChain((Throwable)exception);
                        String errorMessage = null;
                        for (Throwable t : causalChain) {
                            errorMessage = t.getMessage();
                            if (errorMessage != null) break;
                        }
                        return errorMessage;
                    }
                });
                area.showStatus();
            }
        });
    }

    @Subscribe
    public void onEvent(final Events.ProviderOrderChangedEvent e) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean isAbove;
                ProviderArea areaToMove = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                ProviderArea areaRef = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.reference);
                boolean bl = isAbove = e.oldIndex > e.newIndex;
                if (isAbove) {
                    areaToMove.moveAbove(areaRef);
                } else {
                    areaToMove.moveBelow(areaRef);
                }
                ProviderContentPart.this.relayout();
            }
        });
    }

    @Subscribe
    public void onEvent(final Events.ProviderDeactivationEvent e) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProviderArea area = (ProviderArea)ProviderContentPart.this.providerAreas.get(e.provider);
                area.hide();
                area.cleanup();
                area.layout();
                ProviderContentPart.this.relayout();
            }
        });
    }
}

