/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.preferences.PreferencesFacade;
import org.eclipse.recommenders.internal.extdoc.rcp.preferences.ProviderConfigurationPersistenceService;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.ProviderExecutionScheduler;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.SubscriptionManager;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocIconLoader;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ProviderContentPart;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ProviderOverviewPart;
import org.eclipse.recommenders.internal.extdoc.rcp.wiring.ExtdocModule;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.rcp.PartListener2Adapter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class ExtdocView
extends ViewPart {
    public static final String ID = "org.eclipse.recommenders.extdoc.rcp.ExtdocView";
    private final EventBus workspaceBus;
    private final EventBus extdocBus;
    private final SubscriptionManager subscriptionManager;
    private final List<ExtdocProvider> providers;
    private final PreferencesFacade preferences;
    private final ProviderOverviewPart overviewPart;
    private final ProviderContentPart contentPart;
    private ProviderExecutionScheduler scheduler;
    private final Lock schedulerLock = new ReentrantLock();
    private SashForm sashForm;
    protected boolean visible = true;

    @Inject
    public ExtdocView(EventBus workspaceBus, @ExtdocModule.Extdoc EventBus extdocBus, SubscriptionManager subscriptionManager, ExtdocIconLoader iconLoader, List<ExtdocProvider> providers, PreferencesFacade preferences, ProviderOverviewPart overviewPart, ProviderContentPart contentPart, ProviderConfigurationPersistenceService ps) {
        this.workspaceBus = workspaceBus;
        this.extdocBus = extdocBus;
        this.subscriptionManager = subscriptionManager;
        this.providers = providers;
        this.preferences = preferences;
        this.overviewPart = overviewPart;
        this.contentPart = contentPart;
    }

    public void createPartControl(Composite parent) {
        this.createUiElements(parent);
        this.subscribeToEventBusses();
        this.addPartListener();
    }

    private void createUiElements(Composite parent) {
        this.sashForm = new SashForm(parent, 65536);
        this.sashForm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.overviewPart.createControl((Composite)this.sashForm);
        this.contentPart.createControl((Composite)this.sashForm);
        this.sashForm.setWeights(this.preferences.loadSashWeights());
        this.sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtdocView.this.preferences.storeSashWeights(ExtdocView.this.sashForm.getWeights());
            }
        });
    }

    private void subscribeToEventBusses() {
        this.extdocBus.register((Object)this.contentPart);
        this.extdocBus.register((Object)this.overviewPart);
        this.workspaceBus.register((Object)this);
    }

    private void addPartListener() {
        this.getViewSite().getPage().addPartListener((IPartListener2)new PartListener2Adapter(){

            public void partHidden(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ExtdocView.this.visible = false;
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ExtdocView.this.visible = true;
                }
            }

            private boolean isExtdocView(IWorkbenchPartReference partRef) {
                return partRef.getPart(false) == ExtdocView.this;
            }
        });
    }

    public void dispose() {
        this.unsubscribeFromEventBusses();
        this.disposeScheduler();
        super.dispose();
    }

    private void unsubscribeFromEventBusses() {
        this.extdocBus.unregister((Object)this.contentPart);
        this.extdocBus.unregister((Object)this.overviewPart);
        this.workspaceBus.unregister((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onJavaSelection(JavaSelectionEvent selection) {
        if (this.visible) {
            this.disposeScheduler();
            this.scheduleNewSelection(selection);
        }
    }

    private void disposeScheduler() {
        if (this.scheduler != null) {
            this.scheduler.dispose();
            this.scheduler = null;
        }
    }

    private void scheduleNewSelection(JavaSelectionEvent selection) {
        try {
            this.schedulerLock.lock();
            this.scheduler = new ProviderExecutionScheduler(this.providers, this.subscriptionManager, this.contentPart, this.extdocBus);
            this.scheduler.scheduleOnSelection(selection);
        }
        finally {
            this.schedulerLock.unlock();
        }
    }

    public void setFocus() {
        this.contentPart.setFocus();
    }
}

