/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.scheduling;

import com.google.common.base.Optional;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.swt.widgets.Composite;

public class SubscriptionManager {
    private final Multimap<Subscription, Tuple<ExtdocProvider, Method>> subscriptions = LinkedHashMultimap.create();

    @Inject
    public SubscriptionManager(List<ExtdocProvider> providers) {
        Checks.ensureIsNotNull(providers);
        for (ExtdocProvider p : providers) {
            this.register(p);
        }
    }

    private void register(ExtdocProvider provider) {
        Set<Tuple<Method, JavaSelectionSubscriber>> annotatedMethods = this.findAnnotatedMethods(provider);
        if (annotatedMethods.isEmpty()) {
            Throws.throwIllegalArgumentException((String)"no listeners found");
        }
        for (Tuple<Method, JavaSelectionSubscriber> t : annotatedMethods) {
            this.addSubscription(provider, (Method)t.getFirst(), (JavaSelectionSubscriber)t.getSecond());
        }
    }

    private Set<Tuple<Method, JavaSelectionSubscriber>> findAnnotatedMethods(ExtdocProvider provider) {
        LinkedHashSet methods = Sets.newLinkedHashSet();
        Class<?> clazz = provider.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            JavaSelectionSubscriber annotation = m.getAnnotation(JavaSelectionSubscriber.class);
            if (annotation != null) {
                SubscriptionManager.ensureCorrectMethodSignature(m);
                methods.add(Tuple.newTuple((Object)m, (Object)annotation));
            }
            ++n2;
        }
        return methods;
    }

    private static void ensureCorrectMethodSignature(Method m) {
        Class<?>[] params = m.getParameterTypes();
        SubscriptionManager.ensureParameterLengthIsThree(params, m);
        SubscriptionManager.ensureFirstParameterTypeIsJavaElement(params, m);
        SubscriptionManager.ensureSecondParameterTypeIsJavaSelectionEvent(params, m);
        SubscriptionManager.ensureThirdParameterTypeIsComposite(params, m);
        SubscriptionManager.ensureThatAStatusIsReturned(m);
    }

    private static void ensureParameterLengthIsThree(Class<?>[] params, Method m) {
        if (params.length != 3) {
            Throws.throwIllegalArgumentException((String)"error in %s: at least 3 parameters expected", (Object[])new Object[]{m.toGenericString()});
        }
    }

    private static void ensureFirstParameterTypeIsJavaElement(Class<?>[] params, Method m) {
        if (!IJavaElement.class.isAssignableFrom(params[0])) {
            Throws.throwIllegalArgumentException((String)"error in %s: first parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), IJavaElement.class.getName()});
        }
    }

    private static void ensureSecondParameterTypeIsJavaSelectionEvent(Class<?>[] params, Method m) {
        if (!JavaSelectionEvent.class.isAssignableFrom(params[1])) {
            Throws.throwIllegalArgumentException((String)"error in %s: second parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), JavaSelectionEvent.class.getName()});
        }
    }

    private static void ensureThirdParameterTypeIsComposite(Class<?>[] params, Method m) {
        if (!Composite.class.isAssignableFrom(params[2])) {
            Throws.throwIllegalArgumentException((String)"error in %s: third parameter needs to be %s or a subclass", (Object[])new Object[]{m.toGenericString(), Composite.class.getName()});
        }
    }

    private static void ensureThatAStatusIsReturned(Method m) {
        Class<?> actualType = m.getReturnType();
        Class<ExtdocProvider.Status> expectedType = ExtdocProvider.Status.class;
        Checks.ensureEquals(actualType, expectedType, (String)("subscribing methods need to return " + expectedType));
    }

    private void addSubscription(ExtdocProvider provider, Method method, JavaSelectionSubscriber annotation) {
        JavaSelectionEvent.JavaSelectionLocation[] locs = annotation.value();
        Class<?> javaElementType = method.getParameterTypes()[0];
        Tuple subscriber = Tuple.newTuple((Object)provider, (Object)method);
        if (locs.length == 0) {
            Subscription subscription = Subscription.create(javaElementType, null);
            this.subscriptions.put((Object)subscription, (Object)subscriber);
        } else {
            JavaSelectionEvent.JavaSelectionLocation[] javaSelectionLocationArray = locs;
            int n = locs.length;
            int n2 = 0;
            while (n2 < n) {
                JavaSelectionEvent.JavaSelectionLocation loc = javaSelectionLocationArray[n2];
                Subscription subscription = Subscription.create(javaElementType, loc);
                this.subscriptions.put((Object)subscription, (Object)subscriber);
                ++n2;
            }
        }
    }

    public Optional<Method> findSubscribedMethod(ExtdocProvider provider, JavaSelectionEvent selection) {
        for (Subscription s : this.subscriptions.keySet()) {
            if (!s.isInterestedIn(selection)) continue;
            for (Tuple t : this.subscriptions.get((Object)s)) {
                if (!provider.equals(t.getFirst())) continue;
                return Optional.of((Object)((Method)t.getSecond()));
            }
        }
        return Optional.absent();
    }

    public static class Subscription {
        private Class<?> interestedJavaElementClass;
        private JavaSelectionEvent.JavaSelectionLocation interestedLocation;

        public static Subscription create(Class<?> clazz, JavaSelectionEvent.JavaSelectionLocation loc) {
            Subscription subscription = new Subscription();
            subscription.interestedJavaElementClass = clazz;
            subscription.interestedLocation = loc;
            return subscription;
        }

        public boolean isInterestedIn(JavaSelectionEvent selection) {
            return this.isInterestedIn(selection.getElement()) && this.isInterestedIn(selection.getLocation());
        }

        private boolean isInterestedIn(IJavaElement element) {
            return this.interestedJavaElementClass.isAssignableFrom(element.getClass());
        }

        private boolean isInterestedIn(JavaSelectionEvent.JavaSelectionLocation firedLoc) {
            return this.matchesAllLocations() || this.matchesFiredLocation(firedLoc);
        }

        private boolean matchesFiredLocation(JavaSelectionEvent.JavaSelectionLocation firedLoc) {
            return this.interestedLocation.equals((Object)firedLoc);
        }

        private boolean matchesAllLocations() {
            return this.interestedLocation == null;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }
}

